/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlFieldSet;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.ValidityState;

@JsxClass(domClass=HtmlFieldSet.class)
public class HTMLFieldSetElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLFieldSetElement() {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getAlign() {
        return this.getAlign(false);
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean getWillValidate() {
        return ((HtmlFieldSet)this.getDomNodeOrDie()).willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        ((HtmlFieldSet)this.getDomNodeOrDie()).setCustomValidity(message);
    }
}

