/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlLink.class)
public class HTMLLinkElement
extends HTMLElement {
    private static final Log LOG = LogFactory.getLog(HTMLLinkElement.class);
    private CSSStyleSheet sheet_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLLinkElement() {
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlLink link = (HtmlLink)this.getDomNodeOrDie();
        String href = link.getHrefAttribute();
        if (href.isEmpty()) {
            return href;
        }
        try {
            return ((HtmlPage)link.getPage()).getFullyQualifiedUrl(href).toString();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlLink)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlLink)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter
    public String getType() {
        return ((HtmlLink)this.getDomNodeOrDie()).getTypeAttribute();
    }

    public CSSStyleSheet getSheet() {
        if (this.sheet_ == null) {
            try {
                CssStyleSheet sheet = CssStyleSheet.loadStylesheet(this.getDomNodeOrDie(), (HtmlLink)this.getDomNodeOrDie(), null);
                this.sheet_ = new CSSStyleSheet((HTMLElement)this, (Scriptable)this.getWindow(), sheet);
            }
            catch (RuntimeException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"RuntimeException loading stylesheet", (Throwable)e);
                }
                throw Context.reportRuntimeError((String)("Exception: " + e));
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Exception loading stylesheet", (Throwable)e);
                }
                throw Context.reportRuntimeError((String)("Exception: " + e));
            }
        }
        return this.sheet_;
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }
}

