/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlProgress;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;

@JsxClass(domClass=HtmlProgress.class)
public class HTMLProgressElement
extends HTMLElement {
    private NodeList labels_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLProgressElement() {
    }

    @Override
    @JsxGetter
    public Double getValue() {
        return this.getAttributeAsDouble("value", 0.0);
    }

    @JsxGetter
    public double getMax() {
        return this.getAttributeAsDouble("max", 1.0);
    }

    private double getAttributeAsDouble(String attributeName, double defaultValue) {
        try {
            return Double.parseDouble(this.getDomNodeOrDie().getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

