/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.intl;

import java.text.BreakIterator;
import java.util.Locale;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.RecursiveFunctionObject;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE}, className="v8BreakIterator")
public class V8BreakIterator
extends HtmlUnitScriptable {
    private transient BreakIterator breakIterator_;
    private String text_;
    private boolean typeAlwaysNone_;

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        Object types;
        Locale locale = new Locale("en", "US");
        if (args.length != 0) {
            Object locales = args[0];
            if (locales instanceof NativeArray) {
                if (((NativeArray)locales).getLength() != 0L) {
                    locale = new Locale(((NativeArray)locales).get(0).toString());
                }
            } else if (locales instanceof String) {
                locale = new Locale(locales.toString());
            } else if (!Undefined.isUndefined((Object)locales)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new Exception("Unknown type " + locales.getClass().getName()));
            }
        }
        V8BreakIterator iterator = new V8BreakIterator();
        if (args.length > 1 && (types = args[1]) instanceof NativeObject) {
            Object obj = ((NativeObject)types).get("type", (Scriptable)((NativeObject)types));
            if ("character".equals(obj)) {
                iterator.breakIterator_ = BreakIterator.getCharacterInstance(locale);
                iterator.typeAlwaysNone_ = true;
            } else if ("line".equals(obj)) {
                iterator.breakIterator_ = BreakIterator.getLineInstance(locale);
                iterator.typeAlwaysNone_ = true;
            } else if ("sentence".equals(obj)) {
                iterator.breakIterator_ = BreakIterator.getSentenceInstance(locale);
                iterator.typeAlwaysNone_ = true;
            }
        }
        if (iterator.breakIterator_ == null) {
            iterator.breakIterator_ = BreakIterator.getWordInstance(locale);
        }
        Window window = V8BreakIterator.getWindow((Scriptable)ctorObj);
        iterator.setParentScope((Scriptable)window);
        iterator.setPrototype(((RecursiveFunctionObject)ctorObj).getClassPrototype());
        return iterator;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.getClassName();
    }

    @JsxFunction
    public Object resolvedOptions() {
        return Context.getCurrentContext().evaluateString(this.getParentScope(), "var x = {locale: 'en-US'}; x", "", -1, null);
    }

    @JsxFunction
    public int first() {
        return this.breakIterator_.first();
    }

    @JsxFunction
    public int next() {
        return this.breakIterator_.next();
    }

    @JsxFunction
    public int current() {
        return this.breakIterator_.current();
    }

    @JsxFunction
    public void adoptText(String text) {
        this.text_ = text;
        this.breakIterator_.setText(text);
    }

    @JsxFunction
    public String breakType() {
        if (!this.typeAlwaysNone_) {
            int current = this.current();
            int previous = this.breakIterator_.previous();
            if (previous == -1) {
                this.first();
            } else {
                this.next();
            }
            if (current != -1 && previous != -1) {
                String token = this.text_.substring(previous, current);
                if (token.matches(".*[a-zA-Z]+.*")) {
                    return "letter";
                }
                if (token.matches("\\d+")) {
                    return "number";
                }
            }
        }
        return "none";
    }
}

