/*
 * Copyright (c) 2005-2023 Xceptance Software Technologies GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.xceptance.xlt.engine.httprequest;

/**
 * Frequently used HTTP request header names.
 */
public interface HttpRequestHeaders
{
    /**
     * The name of the accept header ("Accept").
     */
    public final String ACCEPT = "Accept";

    /**
     * The name of the accept-charset header ("Accept-Charset").
     */
    public final String ACCEPT_CHARSET = "Accept-Charset";

    /**
     * The name of the accept-encoding header ("Accept-Encoding").
     */
    public final String ACCEPT_ENCODING = "Accept-Encoding";

    /**
     * The name of the accept-language header ("Accept-Language").
     */
    public final String ACCEPT_LANGUAGE = "Accept-Language";

    /**
     * The name of the authorization header ("Authorization").
     */
    public final String AUTHORIZATION = "Authorization";

    /**
     * The name of the cache-control header ("Cache-Control").
     */
    public final String CACHE_CONTROL = "Cache-Control";

    /**
     * The name of the connection header ("Connection").
     */
    public final String CONNECTION = "Connection";

    /**
     * The name of the cookie header ("Cookie").
     */
    public final String COOKIE = "Cookie";

    /**
     * The name of the content-length header ("Content-Length").
     */
    public final String CONTENT_LENGTH = "Content-Length";

    /**
     * The name of the content-md5 header ("Content-MD5").
     */
    public final String CONTENT_MD5 = "Content-MD5";

    /**
     * The name of the content-type header ("Content-Type").
     */
    public final String CONTENT_TYPE = "Content-Type";

    /**
     * The name of the date header ("Date").
     */
    public final String DATE = "Date";

    /**
     * The name of the expect header ("Expect").
     */
    public final String EXPECT = "Expect";

    /**
     * The name of the from header ("From").
     */
    public final String FROM = "From";

    /**
     * The name of the host header ("Host").
     */
    public final String HOST = "Host";

    /**
     * The name of the if-match header ("If-Match").
     */
    public final String IF_MATCH = "If-Match";

    /**
     * The name of the if-modified-since header ("If-Modified-Since").
     */
    public final String IF_MODIFIED_SINCE = "If-Modified-Since";

    /**
     * The name of the if-none-match header ("If-None-Match").
     */
    public final String IF_NONE_MATCH = "If-None-Match";

    /**
     * The name of the if-range header ("If-Range").
     */
    public final String IF_RANGE = "If-Range";

    /**
     * The name of the if-unmodified-since header ("If-Unmodified-Since").
     */
    public final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";

    /**
     * The name of the max-forwards header ("Max-Forwards").
     */
    public final String MAX_FORWARDS = "Max-Forwards";

    /**
     * The name of the pragma header ("Pragma").
     */
    public final String PRAGMA = "Pragma";

    /**
     * The name of the proxy-authorization header ("Proxy-Authorization").
     */
    public final String PROXY_AUTHORIZATION = "Proxy-Authorization";

    /**
     * The name of the range header ("Range").
     */
    public final String RANGE = "Range";

    /**
     * The name of the referrer header ("Referrer").
     */
    public final String REFERER = "Referer";

    /**
     * The name of the te header ("TE").
     */
    public final String TE = "TE";

    /**
     * The name of the transfer-encoding header ("Transfer-Encoding").
     */
    public final String TRANSFER_ENCODING = "Transfer-Encoding";

    /**
     * The name of the upgrade header ("Upgrade").
     */
    public final String UPGRADE = "Upgrade";

    /**
     * The name of the user-agent header ("User-Agent").
     */
    public final String USER_AGENT = "User-Agent";

    /**
     * The name of the via header ("Via").
     */
    public final String VIA = "Via";

    /**
     * The name of the warning header ("Warning").
     */
    public final String WARNING = "Warning";

    /**
     * The name of the custom requested-with header ("X-Requested-With").
     */
    public final String X_REQUESTED_WITH = "X-Requested-With";

    /**
     * The name of the custom do-not-track header ("X-Do-Not-Track").
     */
    public final String X_DO_NOT_TRACK = "X-Do-Not-Track";

    /**
     * The name of the do-not-track header ("DNT").
     */
    public final String DNT = "DNT";

    /**
     * The name of the custom forwarded-for header ("X-Forwarded-For").
     */
    public final String X_FORWARDED_FOR = "X-Forwarded-For";

    /**
     * The name of the custom forwarded-protocol header ("X-Forwarded-Proto").
     */
    public final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
}
