/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.xlt.api.util.XltLogger;
import java.text.ParseException;
import java.util.Properties;

public abstract class AbstractCustomSampler {
    private Properties properties = new Properties();
    private long interval = -1L;
    private String name = null;

    public void initialize() {
    }

    public abstract double execute();

    public void shutdown() {
    }

    public void setInterval(long interval) {
        ParameterCheckUtils.isGreaterThan((int)interval, -1, "interval");
        this.interval = interval;
    }

    public void setInterval(String interval) {
        long samplingInterval;
        if (interval.matches("\\d+")) {
            XltLogger.runTimeLogger.info("The interval property now supports the common XLT way to specify a duration which we recommend!");
            samplingInterval = Long.parseLong(interval);
        } else {
            try {
                samplingInterval = (long)ParseUtils.parseTimePeriod(interval) * 1000L;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid value for interval : \"" + interval + "\"", e);
            }
        }
        this.setInterval(samplingInterval);
    }

    public long getInterval() {
        return this.interval;
    }

    public void setName(String name) {
        ParameterCheckUtils.isNonEmptyString(name, "name");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

