/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.DataManager;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.metrics.Metrics;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DataManagerImpl
implements DataManager {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private boolean loggingEnabled = true;
    private long startOfLoggingPeriod = Long.MIN_VALUE;
    private long endOfLoggingPeriod = Long.MAX_VALUE;
    private int numberOfEvents;
    private volatile BufferedWriter logger;
    private final Metrics metrics;
    private final Session session;

    protected DataManagerImpl(Session session, Metrics metrics) {
        this.session = session;
        this.metrics = metrics;
    }

    protected DataManagerImpl(Session session) {
        this.session = session;
        this.metrics = null;
    }

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    @Override
    public void logEvent(String eventName, String message) {
        EventData e = new EventData(eventName);
        e.setTime(GlobalClock.millis());
        e.setTestCaseName(this.session.getUserName());
        e.setMessage(message);
        this.logDataRecord(e);
    }

    @Override
    public void logDataRecord(Data stats) {
        if (this.metrics != null) {
            this.metrics.updateMetrics(stats);
        }
        long time = stats.getTime();
        if (this.loggingEnabled && this.startOfLoggingPeriod <= time && time <= this.endOfLoggingPeriod) {
            BufferedWriter timerWriter;
            BufferedWriter bufferedWriter = timerWriter = this.logger != null ? this.logger : this.getTimerLogger();
            if (timerWriter == null) {
                return;
            }
            try {
                StringBuilder s = DataManagerImpl.removeLineSeparators(stats.toCSV(), ' ');
                s.append(LINE_SEPARATOR);
                timerWriter.write(s.toString());
                timerWriter.flush();
            }
            catch (IOException ex) {
                XltLogger.runTimeLogger.error("Failed to write statistics:", (Throwable)ex);
            }
            if (stats instanceof EventData) {
                ++this.numberOfEvents;
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    EventData event = (EventData)stats;
                    XltLogger.runTimeLogger.warn(String.format("EVENT: %2$s - %1$s - '%3$s'", event.getName(), event.getTestCaseName(), event.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getTimerLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        DataManagerImpl dataManagerImpl = this;
        synchronized (dataManagerImpl) {
            if (this.logger != null) {
                return this.logger;
            }
            Path file = this.getTimerFile();
            if (file == null) {
                return null;
            }
            try {
                this.logger = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Cannot create writer for file: " + file.toString(), (Throwable)e);
            }
        }
        return this.logger;
    }

    Path getTimerFile() {
        Path dir = this.session.getResultsDirectory();
        if (dir == null) {
            throw new RuntimeException("Missing result dir, see previous exceptions.");
        }
        Path file = dir.resolve("timers.csv");
        return file;
    }

    public boolean close() {
        if (this.logger != null) {
            try {
                BufferedWriter l = this.logger;
                this.logger = null;
                if (l != null) {
                    l.close();
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long getStartOfLoggingPeriod() {
        return this.startOfLoggingPeriod;
    }

    @Override
    public long getEndOfLoggingPeriod() {
        return this.endOfLoggingPeriod;
    }

    @Override
    public void setStartOfLoggingPeriod(long time) {
        this.startOfLoggingPeriod = time;
    }

    @Override
    public void setEndOfLoggingPeriod(long time) {
        this.endOfLoggingPeriod = time;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void enableLogging() {
        this.loggingEnabled = true;
    }

    @Override
    public void disableLogging() {
        this.loggingEnabled = false;
    }

    @Override
    public void setLoggingEnabled(boolean state) {
        if (state) {
            this.enableLogging();
        } else {
            this.disableLogging();
        }
    }

    static StringBuilder removeLineSeparators(StringBuilder src, char replacementChar) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != '\n' && c != '\r') continue;
            src.setCharAt(i, replacementChar);
        }
        return src;
    }
}

