/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import com.xceptance.xlt.engine.htmlunit.okhttp3.AuthenticationCache;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AuthorizationHeaderInterceptor
implements Interceptor {
    private final AuthenticationCache authenticationCache;

    AuthorizationHeaderInterceptor(AuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String hostAndPort = request.url().host() + ":" + request.url().port();
        String authHeaderValue = request.header("Authorization");
        if (authHeaderValue == null) {
            authHeaderValue = this.authenticationCache.getAuthHeaderValue(hostAndPort);
            if (authHeaderValue != null) {
                request = request.newBuilder().header("Authorization", authHeaderValue).build();
            }
        } else {
            this.authenticationCache.putAuthHeaderValue(hostAndPort, authHeaderValue);
        }
        return chain.proceed(request);
    }
}

