/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.engine.scripting.TestDataUtils;
import com.xceptance.xlt.engine.scripting.docgen.BaseInfo;
import com.xceptance.xlt.engine.scripting.docgen.JavaModuleInfo;
import com.xceptance.xlt.engine.scripting.docgen.Marked;
import com.xceptance.xlt.engine.scripting.docgen.ModuleScriptInfo;
import com.xceptance.xlt.engine.scripting.docgen.PackageInfo;
import com.xceptance.xlt.engine.scripting.docgen.TestScriptInfo;
import com.xceptance.xlt.engine.util.ScriptingUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@XStreamAlias(value="testsuite")
public class TestSuiteInfo {
    String name;
    String description;
    private final Set<TestScriptInfo> tests = new HashSet<TestScriptInfo>();
    private final Set<ModuleScriptInfo> modules = new HashSet<ModuleScriptInfo>();
    @XStreamAlias(value="java-modules")
    private final Set<JavaModuleInfo> javaModules = new HashSet<JavaModuleInfo>();
    private final Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
    @XStreamAlias(value="global-testdata")
    private final Map<String, String> globalTestData;
    private transient String descriptionMarkup;

    TestSuiteInfo(File suitePath) {
        this.name = suitePath.getName();
        this.globalTestData = this.readGlobalTestData(suitePath);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionMarkup() {
        if (this.descriptionMarkup == null) {
            this.descriptionMarkup = Marked.getInstance().markdownToHTML(this.description);
        }
        return this.descriptionMarkup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readGlobalTestData(File suitePath) {
        Map<String, String> data;
        XltExecutionContext ctx = XltExecutionContext.getCurrent();
        File f = ctx.getTestSuiteHomeDirAsFile();
        try {
            ctx.setTestSuiteHomeDir(suitePath);
            data = TestDataUtils.getGlobalTestData();
            if (!data.isEmpty()) {
                data = new TreeMap<String, String>(data);
            }
        }
        finally {
            ctx.setTestSuiteHomeDir(f);
        }
        return data;
    }

    void addScript(BaseInfo info) {
        if (info instanceof TestScriptInfo) {
            this.tests.add((TestScriptInfo)info);
        } else if (info instanceof ModuleScriptInfo) {
            this.modules.add((ModuleScriptInfo)info);
        } else if (info instanceof JavaModuleInfo) {
            this.javaModules.add((JavaModuleInfo)info);
        } else {
            throw new IllegalArgumentException("Don't know how to handle class '" + info.getClass().getCanonicalName() + "'");
        }
        String packageName = ScriptingUtils.getScriptPackage(info.getName());
        PackageInfo pkgInfo = this.packages.get(packageName);
        if (pkgInfo == null) {
            throw new IllegalArgumentException("Don't know such package '" + packageName + "'");
        }
        pkgInfo.addScript(info);
    }

    void addPackage(PackageInfo pkg) {
        this.packages.put(pkg.getName(), pkg);
    }

    public Map<String, String> getGlobalTestData() {
        return this.globalTestData;
    }

    public String getName() {
        return this.name;
    }

    public Collection<TestScriptInfo> getTests() {
        return this.tests;
    }

    public Collection<ModuleScriptInfo> getModules() {
        return this.modules;
    }

    public Collection<JavaModuleInfo> getJavaModules() {
        return this.javaModules;
    }

    public Map<String, PackageInfo> getPackages() {
        return Collections.unmodifiableMap(this.packages);
    }
}

