/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.util.RegExUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebResponse;
import org.htmlunit.util.UrlUtils;

public final class CssUtils {
    private static final String IMPORT_RULE_PATTERN = "(?m)@import\\s+(['\"])([^'\"]+?)\\1.*?;";
    private static final String URL_PATTERN = "url\\(\\s*(?:(['\"])([^'\")]+?)\\1|([^'\")]+?))\\s*\\)";
    private static final String IMPORT_ONLY_RULE_PATTERN = "(?m)@import\\s+(?:url\\(\\s*(?:(['\"])([^'\")]+?)\\1|([^'\")]+?))\\s*\\)|(['\"])([^'\"]+?)\\4).*?;";
    private static final String CSS_NAMESPACE_PATTERN = "(?m)@namespace\\s+url\\([^)]+?\\)\\s*[;}]";
    private static final String COMMENT_PATTERN = "(?sm)/\\*.*?\\*/";

    public static List<URL> getResourceUrls(String cssContent, String baseUrl) {
        try {
            return CssUtils.getResourceUrls(cssContent, new URL(baseUrl));
        }
        catch (MalformedURLException e) {
            return Collections.emptyList();
        }
    }

    public static Set<String> getUrlStrings(String cssContent) {
        if (StringUtils.isEmpty((CharSequence)cssContent)) {
            return Collections.emptySet();
        }
        HashSet<String> urls = new HashSet<String>();
        String cleanContent = CssUtils.cleanCSS(cssContent);
        ArrayList<String> resources = new ArrayList<String>();
        Matcher m = RegExUtils.getPattern(URL_PATTERN).matcher(cleanContent);
        while (m.find()) {
            int groupCount = m.groupCount();
            String match = m.group(groupCount);
            if (match == null) {
                match = m.group(groupCount - 1);
            }
            resources.add(match);
        }
        resources.addAll(RegExUtils.getAllMatches(cleanContent, IMPORT_RULE_PATTERN, 2));
        for (String s : resources) {
            String match = s.trim();
            if (match.length() <= 0) continue;
            urls.add(match);
        }
        return urls;
    }

    public static List<URL> getResourceUrls(String cssContent, URL baseUrl) {
        return CssUtils.createAbsoluteUrls(CssUtils.getUrlStrings(cssContent), baseUrl);
    }

    public static List<URL> getResourceUrls(WebResponse response) {
        return CssUtils.getResourceUrls(response, response.getWebRequest().getUrl());
    }

    public static List<URL> getResourceUrls(WebResponse response, URL baseURL) {
        if (CssUtils.isCssResponse(response)) {
            return CssUtils.getResourceUrls(response.getContentAsString(), baseURL);
        }
        return Collections.emptyList();
    }

    public static List<URL> getImportUrls(WebResponse response) {
        if (CssUtils.isCssResponse(response)) {
            return CssUtils.getImportUrls(response.getContentAsString(), response.getWebRequest().getUrl());
        }
        return Collections.emptyList();
    }

    public static List<URL> getImportUrls(String cssContent, URL baseURL) {
        return CssUtils.createAbsoluteUrls(CssUtils.getRelativeImportUrlStrings(cssContent), baseURL);
    }

    public static Set<String> getRelativeImportUrlStrings(String cssContent) {
        if (StringUtils.isEmpty((CharSequence)cssContent)) {
            return Collections.emptySet();
        }
        String cleanContent = CssUtils.cleanCSS(cssContent);
        HashSet<String> urls = new HashSet<String>();
        Matcher m = RegExUtils.getPattern(IMPORT_ONLY_RULE_PATTERN).matcher(cleanContent);
        while (m.find()) {
            String match = null;
            for (int group = m.groupCount(); group > 0 && match == null; --group) {
                match = m.group(group);
            }
            if (match == null || (match = match.trim()).length() <= 0) continue;
            urls.add(match);
        }
        return urls;
    }

    public static boolean isCssResponse(WebResponse response) {
        if (response != null) {
            URL url = response.getWebRequest().getUrl();
            if (url != null && url.getPath().toLowerCase().endsWith(".css")) {
                return true;
            }
            if (response.getContentType() != null && response.getContentType().trim().equalsIgnoreCase("text/css")) {
                return true;
            }
        }
        return false;
    }

    public static String clearImportRules(String cssContent) {
        return RegExUtils.replaceAll(cssContent, IMPORT_ONLY_RULE_PATTERN, "");
    }

    public static String clearImportRules(WebResponse response) {
        if (CssUtils.isCssResponse(response)) {
            return CssUtils.clearImportRules(response.getContentAsString());
        }
        return "";
    }

    private static List<URL> createAbsoluteUrls(Collection<String> relativeUrls, URL baseUrl) {
        if (baseUrl == null || relativeUrls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>(relativeUrls.size());
        for (String urlString : relativeUrls) {
            URL url = CssUtils.resolveUrl(baseUrl, urlString);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private static URL resolveUrl(URL baseUrl, String relativeUrl) {
        try {
            return new URL(UrlUtils.resolveUrl(baseUrl, relativeUrl));
        }
        catch (MalformedURLException mfe) {
            return null;
        }
    }

    private static String cleanCSS(String cssContent) {
        if (cssContent == null) {
            return null;
        }
        String cleanCSS = RegExUtils.replaceAll(cssContent, CSS_NAMESPACE_PATTERN, "");
        cleanCSS = RegExUtils.replaceAll(cleanCSS, COMMENT_PATTERN, "");
        return cleanCSS;
    }

    private CssUtils() {
    }
}

