/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

class GceAdminConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "xlt.gce.";
    private static final String PROP_APPLICATION_NAME = "xlt.gce.applicationName";
    private static final String PROP_INSTANCE_CONNECT_TIMEOUT = "xlt.gce.instanceConnectTimeout";
    private static final String PROP_PROJECT_ID = "xlt.gce.projectId";
    private final long instanceConnectTimeout;
    private final String projectId;
    private String applicationName;

    GceAdminConfiguration() throws IOException {
        File configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        File propFile = new File(configDirectory, "gce_admin.properties");
        this.loadProperties(propFile);
        this.instanceConnectTimeout = this.getLongProperty(PROP_INSTANCE_CONNECT_TIMEOUT, 300L) * 1000L;
        if (this.instanceConnectTimeout < 0L) {
            throw new XltException(String.format("Property '%s' cannot be negative", PROP_INSTANCE_CONNECT_TIMEOUT));
        }
        this.projectId = this.getStringProperty(PROP_PROJECT_ID, "").trim();
        if (StringUtils.isEmpty((CharSequence)this.projectId)) {
            throw new XltException(String.format("Property '%s' is not set", PROP_PROJECT_ID));
        }
        this.applicationName = this.getStringProperty(PROP_APPLICATION_NAME, "").trim();
        if (StringUtils.isEmpty((CharSequence)this.applicationName)) {
            this.applicationName = "xlt-gce-admin";
        }
    }

    String getApplicationName() {
        return this.applicationName;
    }

    long getInstanceConnectTimeout() {
        return this.instanceConnectTimeout;
    }

    String getProjectId() {
        return this.projectId;
    }
}

