/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.diffreport;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.util.ElementSpecification;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DiffReportGeneratorConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.diffreportgenerator.";
    private static final String PROP_REPORTS_ROOT_DIR = "com.xceptance.xlt.diffreportgenerator.reports";
    private final File configDirectory;
    private final File homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
    private final File reportsRootDirectory;

    public DiffReportGeneratorConfiguration() throws IOException {
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        this.loadProperties(new File(this.configDirectory, "diffreportgenerator.properties"));
        File reportsRootDir = this.getFileProperty(PROP_REPORTS_ROOT_DIR, new File(this.homeDirectory, "reports"));
        if (!reportsRootDir.isAbsolute()) {
            reportsRootDir = new File(this.homeDirectory, reportsRootDir.getPath());
        }
        this.reportsRootDirectory = reportsRootDir;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public List<ElementSpecification> getDiffElementSpecifications() {
        ArrayList<ElementSpecification> specs = new ArrayList<ElementSpecification>();
        specs.add(new ElementSpecification("/testreport/transactions/transaction", "name"));
        specs.add(new ElementSpecification("/testreport/actions/action", "name"));
        specs.add(new ElementSpecification("/testreport/requests/request", "name"));
        specs.add(new ElementSpecification("/testreport/pageLoadTimings/pageLoadTiming", "name"));
        specs.add(new ElementSpecification("/testreport/customTimers/customTimer", "name"));
        specs.add(new ElementSpecification("/testreport/summary/*", "name"));
        return specs;
    }

    public List<ElementSpecification> getCopyElementSpecifications() {
        ArrayList<ElementSpecification> specs = new ArrayList<ElementSpecification>();
        specs.add(new ElementSpecification("/testreport/general", null));
        specs.add(new ElementSpecification("/testreport/configuration/loadProfile", null));
        specs.add(new ElementSpecification("/testreport/configuration/comments", null));
        specs.add(new ElementSpecification("/testreport/configuration/properties", null));
        specs.add(new ElementSpecification("/testreport/configuration/projectName", null));
        return specs;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getReportsRootDirectory() {
        return this.reportsRootDirectory;
    }
}

