/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.report.providers.ConfigurationReport;
import com.xceptance.xlt.util.PropertiesConfigurationException;
import com.xceptance.xlt.util.PropertiesIOException;
import com.xceptance.xlt.util.PropertyFileNotFoundException;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class ConfigurationReportProvider
extends AbstractReportProvider {
    private static final String LOADTEST_PROP = "com.xceptance.xlt.loadtests";
    private static final String MASK_PROPERTIES_PROP = "com.xceptance.xlt.reportgenerator.maskPropertiesRegex";
    private static final String MASK_PROPERTIES_REGEX_DEFAULT = "(?i)password";

    @Override
    public Object createReportFragment() {
        XltPropertiesImpl props;
        ConfigurationReport report = new ConfigurationReport();
        File reportDirectory = this.getConfiguration().getReportDirectory();
        File configDir = new File(reportDirectory, "config");
        try {
            FileSystemManager fsMgr = VFS.getManager();
            props = new XltPropertiesImpl(fsMgr.resolveFile(reportDirectory.getAbsolutePath()), fsMgr.resolveFile(configDir.getAbsolutePath()), false, true);
        }
        catch (PropertiesConfigurationException | PropertiesIOException | PropertyFileNotFoundException | FileSystemException e) {
            System.err.println();
            return report;
        }
        File jvmArgsFile = new File(configDir, "jvmargs.cfg");
        report.properties.putAll(this.mask(props.getProperties()));
        report.version = ProductInformation.getProductInformation();
        TreeMap<String, String> sortedLoadtestProps = new TreeMap<String, String>();
        Map<String, String> loadtestProps = props.getPropertiesForKey(LOADTEST_PROP);
        for (Map.Entry<String, String> entry : loadtestProps.entrySet()) {
            String propName = entry.getKey();
            if (!RegExUtils.isMatching(propName, "(comment\\.?\\d*$)|(comment\\.commandLine$)")) continue;
            sortedLoadtestProps.put(propName, entry.getValue());
        }
        for (Map.Entry<String, String> entry : sortedLoadtestProps.entrySet()) {
            report.comments.add(entry.getValue());
        }
        String projectName = props.getProperty("com.xceptance.xlt.projectName");
        report.projectName = StringUtils.isNotBlank((CharSequence)projectName) ? projectName.trim() : null;
        try {
            report.loadProfile = new TestLoadProfileConfiguration(props).getLoadTestConfiguration();
        }
        catch (Exception exception) {
            System.err.println("Failed to get load test profile configuration. Cause: " + exception.getMessage());
        }
        try {
            report.customJvmArgs = this.getCustomJvmArgs(jvmArgsFile);
        }
        catch (IOException iOException) {
            System.err.println("Failed to get custom JVM arguments. Cause: " + iOException.getMessage());
        }
        report.chartHeight = this.getConfiguration().getChartHeight();
        report.chartWidth = this.getConfiguration().getChartWidth();
        return report;
    }

    private Map<? extends Object, ? extends Object> mask(Properties properties) {
        String MASK_PROPERTIES_REGEX = this.getConfiguration().getProperties().getProperty(MASK_PROPERTIES_PROP, MASK_PROPERTIES_REGEX_DEFAULT);
        boolean isMaskSet = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{MASK_PROPERTIES_REGEX});
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String propName = (String)entry.getKey();
            if (!propName.startsWith("secret.") && (!isMaskSet || !RegExUtils.isMatching(propName, MASK_PROPERTIES_REGEX))) continue;
            properties.replace(propName, "******");
        }
        return properties;
    }

    @Override
    public void processDataRecord(Data data) {
    }

    @Override
    public boolean wantsDataRecords() {
        return false;
    }

    private List<String> getCustomJvmArgs(File file) throws IOException {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        if (file.isFile()) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    int i = line.indexOf(35);
                    if (i >= 0) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    jvmArgs.add(line);
                }
            }
        }
        return jvmArgs;
    }
}

