/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.BasicTimerDataProcessor;
import com.xceptance.xlt.report.providers.TimerReport;
import com.xceptance.xlt.report.providers.TransactionReport;
import com.xceptance.xlt.report.util.ConcurrentUsersTable;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import java.io.File;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;

public class TransactionDataProcessor
extends BasicTimerDataProcessor {
    private final ValueSet eventsPerSecond = new ValueSet();
    private final ValueSet arrivalsPerHourPerSecond = new ValueSet();
    private int numberOfEvents = 0;

    public TransactionDataProcessor(String name, AbstractReportProvider provider) {
        super(name, provider);
        this.setChartDir(new File(this.getChartDir(), "transactions"));
        this.setCsvDir(new File(this.getCsvDir(), "transactions"));
        ReportGeneratorConfiguration config = (ReportGeneratorConfiguration)this.getConfiguration();
        this.setChartCappingInfo(config.getTransactionChartCappingInfo());
    }

    @Override
    public TimerReport createTimerReport(boolean generateHistogram) {
        if (this.getConfiguration().shouldChartsGenerated()) {
            TaskManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    ValueSet concurrentUsersVS = ConcurrentUsersTable.getInstance().getConcurrentUsersValueSet(TransactionDataProcessor.this.getName());
                    TimeSeries concurrentUsersTS = JFreeChartUtils.toMinMaxTimeSeries(concurrentUsersVS.toMinMaxValueSet(TransactionDataProcessor.this.getChartWidth()), "Concurrent Users");
                    TransactionDataProcessor.this.createChart(concurrentUsersTS, true, TransactionDataProcessor.this.getName(), "Users", TransactionDataProcessor.this.getName() + "_ConcurrentUsers", TransactionDataProcessor.this.getChartDir(), "concurrent users", true);
                }
            });
            TaskManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    TimeSeries arrivalRateTS = JFreeChartUtils.toMinMaxTimeSeries(TransactionDataProcessor.this.arrivalsPerHourPerSecond.toMinMaxValueSet(TransactionDataProcessor.this.getChartWidth()), "Current Arrival Rate");
                    TimeSeries averagedArrivalRateTS = JFreeChartUtils.createMovingAverageTimeSeries(arrivalRateTS, TransactionDataProcessor.this.getMovingAveragePercentage());
                    averagedArrivalRateTS.setKey((Comparable)((Object)"Current Arrival Rate"));
                    TransactionDataProcessor.this.createChart(averagedArrivalRateTS, true, TransactionDataProcessor.this.getName(), "Arrival Rate [1/h]", TransactionDataProcessor.this.getName() + "_ArrivalRate", TransactionDataProcessor.this.getChartDir(), "arrival rate", false);
                }
            });
        }
        TransactionReport transactionReport = (TransactionReport)super.createTimerReport(generateHistogram);
        transactionReport.events = this.numberOfEvents;
        return transactionReport;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof TransactionData) {
            super.processDataRecord(data);
            this.arrivalsPerHourPerSecond.addOrUpdateValue(data.getTime(), 3600);
        } else {
            this.eventsPerSecond.addOrUpdateValue(data.getTime(), 1);
            ++this.numberOfEvents;
        }
    }

    @Override
    protected JFreeChart createResponseTimeAndErrorsChart(String name, TimeSeries responseTimeSeries, TimeSeries responseTimeAverageSeries, XYIntervalSeries responseTimeHistogramSeries, TimeSeries errorsSeries, int chartCappingValue) {
        JFreeChart chart = super.createResponseTimeAndErrorsChart(name, responseTimeSeries, responseTimeAverageSeries, responseTimeHistogramSeries, errorsSeries, chartCappingValue);
        CombinedRangeXYPlot outerCombinedPlot = (CombinedRangeXYPlot)chart.getXYPlot();
        List subPlots = outerCombinedPlot.getSubplots();
        CombinedDomainXYPlot leftCombinedPlot = (CombinedDomainXYPlot)subPlots.get(0);
        CombinedDomainXYPlot rightCombinedPlot = (CombinedDomainXYPlot)subPlots.get(1);
        int minMaxValueSetSize = this.getChartWidth();
        TimeSeries errorRateTimeSeries = JFreeChartUtils.calculateRateTimeSeries(this.getErrorsPerSecondValueSet(), this.getCountPerSecondValueSet(), minMaxValueSetSize, "Error Rate");
        TimeSeries errorRateAverageTimeSeries = JFreeChartUtils.createMovingAverageTimeSeries(errorRateTimeSeries, this.getMovingAveragePercentage());
        XYPlot errorRatePlot = JFreeChartUtils.createLinePlot((XYDataset)new TimeSeriesCollection(errorRateAverageTimeSeries), null, "Errors [%]", new JFreeChartUtils.ColorSet(JFreeChartUtils.COLOR_ERROR));
        ValueAxis errorRateAxis = errorRatePlot.getRangeAxis();
        errorRateAxis.setLowerBound(0.0);
        double maxRate = errorRateAverageTimeSeries.getMaxY();
        if (0.0 < maxRate && maxRate < 1.0) {
            errorRateAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        }
        leftCombinedPlot.add(errorRatePlot, 1);
        rightCombinedPlot.add(JFreeChartUtils.createSpacerPlot(), 1);
        TimeSeries eventsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(this.eventsPerSecond.toMinMaxValueSet(minMaxValueSetSize), "Events/s");
        TimeSeriesCollection eventsPerSecondTimeSeriesCollection = new TimeSeriesCollection(eventsPerSecondTimeSeries);
        XYPlot eventPlot = JFreeChartUtils.createBarPlot((XYDataset)eventsPerSecondTimeSeriesCollection, null, "Events", JFreeChartUtils.COLOR_EVENT);
        leftCombinedPlot.add(eventPlot, 1);
        rightCombinedPlot.add(JFreeChartUtils.createSpacerPlot(), 1);
        return chart;
    }

    protected void createChart(TimeSeries timeSeries, boolean showMovingAverage, String title, String yAxisTitle, String fileName, File outputDir, String chartType, boolean showDots) {
        ReportProviderConfiguration config = this.getConfiguration();
        JFreeChart chart = JFreeChartUtils.createLineChart(title, yAxisTitle, timeSeries, config.getChartStartTime(), config.getChartEndTime(), showMovingAverage, config.getMovingAveragePercentage(), showDots);
        JFreeChartUtils.saveChart(chart, fileName, outputDir, config.getChartWidth(), config.getChartHeight());
    }

    @Override
    protected TimerReport createTimerReport() {
        return new TransactionReport();
    }
}

