/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlMap;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.util.geometry.Circle2D;
import org.htmlunit.util.geometry.Polygon2D;
import org.htmlunit.util.geometry.Rectangle2D;
import org.htmlunit.util.geometry.Shape2D;

public class HtmlArea
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlArea.class);
    public static final String TAG_NAME = "area";
    private static final String SHAPE_RECT = "rect";
    private static final String SHAPE_CIRCLE = "circle";
    private static final String SHAPE_POLY = "poly";

    HtmlArea(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlPage enclosingPage = (HtmlPage)this.getPage();
        WebClient webClient = enclosingPage.getWebClient();
        String href = this.getHrefAttribute().trim();
        if (!href.isEmpty()) {
            URL url;
            HtmlPage page = (HtmlPage)this.getPage();
            if (StringUtils.startsWithIgnoreCase((CharSequence)href, (CharSequence)"javascript:")) {
                page.executeJavaScript(href, "javascript url", this.getStartLineNumber());
                return false;
            }
            try {
                url = enclosingPage.getFullyQualifiedUrl(this.getHrefAttribute());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Not a valid url: " + this.getHrefAttribute(), e);
            }
            WebRequest request = new WebRequest(url, page.getCharset(), page.getUrl());
            WebWindow webWindow = enclosingPage.getEnclosingWindow();
            String target = enclosingPage.getResolvedTarget(this.getTargetAttribute());
            webClient.getPage(webClient.openTargetWindow(webWindow, target, "_self"), request);
        }
        return false;
    }

    public final String getShapeAttribute() {
        return this.getAttributeDirect("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeDirect("coords");
    }

    public final String getHrefAttribute() {
        return this.getAttributeDirect("href");
    }

    public final String getNoHrefAttribute() {
        return this.getAttributeDirect("nohref");
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    boolean containsPoint(int x, int y) {
        String shape = ((String)StringUtils.defaultIfEmpty((CharSequence)this.getShapeAttribute(), (CharSequence)SHAPE_RECT)).toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return true;
        }
        if (SHAPE_RECT.equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.contains(x, y);
        }
        if (SHAPE_CIRCLE.equals(shape) && this.getCoordsAttribute() != null) {
            Circle2D circle = this.parseCircle();
            return circle.contains(x, y);
        }
        if (SHAPE_POLY.equals(shape) && this.getCoordsAttribute() != null) {
            Shape2D path = this.parsePoly();
            return path.contains(x, y);
        }
        return false;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        DomNode parent = this.getParentNode();
        if (parent instanceof HtmlMap && parent.isDisplayed()) {
            return !this.isEmpty();
        }
        return false;
    }

    private Rectangle2D parseRect() {
        double bottomY;
        double rightX;
        double topY;
        double leftX;
        block6: {
            Object[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
            leftX = 0.0;
            topY = 0.0;
            rightX = 0.0;
            bottomY = 0.0;
            try {
                if (coords.length > 0) {
                    leftX = Double.parseDouble(coords[0].trim());
                }
                if (coords.length > 1) {
                    topY = Double.parseDouble(((String)coords[1]).trim());
                }
                if (coords.length > 2) {
                    rightX = Double.parseDouble(((String)coords[2]).trim());
                }
                if (coords.length > 3) {
                    bottomY = Double.parseDouble(((String)coords[3]).trim());
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)("Invalid rect coords '" + Arrays.toString(coords) + "'"), (Throwable)e);
            }
        }
        return new Rectangle2D(leftX, topY, rightX, bottomY);
    }

    private Circle2D parseCircle() {
        Object[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
        double centerX = 0.0;
        double centerY = 0.0;
        double radius = 0.0;
        try {
            if (coords.length > 0) {
                centerX = Double.parseDouble(((String)coords[0]).trim());
            }
            if (coords.length > 1) {
                centerY = Double.parseDouble(((String)coords[1]).trim());
            }
            if (coords.length > 2) {
                radius = Double.parseDouble(((String)coords[2]).trim());
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Invalid circle coords '" + Arrays.toString(coords) + "'"), (Throwable)e);
        }
        return new Circle2D(centerX, centerY, radius);
    }

    private Shape2D parsePoly() {
        block4: {
            Object[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
            try {
                if (coords.length > 1) {
                    Polygon2D path = new Polygon2D(Double.parseDouble((String)coords[0]), Double.parseDouble((String)coords[1]));
                    int i = 2;
                    while (i + 1 < coords.length) {
                        path.lineTo(Double.parseDouble((String)coords[i]), Double.parseDouble((String)coords[i + 1]));
                        i += 2;
                    }
                    return path;
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)("Invalid poly coords '" + Arrays.toString(coords) + "'"), (Throwable)e);
            }
        }
        return new Rectangle2D(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }

    private boolean isEmpty() {
        String shape = ((String)StringUtils.defaultIfEmpty((CharSequence)this.getShapeAttribute(), (CharSequence)SHAPE_RECT)).toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return false;
        }
        if (SHAPE_RECT.equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.isEmpty();
        }
        if (SHAPE_CIRCLE.equals(shape) && this.getCoordsAttribute() != null) {
            Circle2D circle = this.parseCircle();
            return circle.isEmpty();
        }
        if (SHAPE_POLY.equals(shape) && this.getCoordsAttribute() != null) {
            Shape2D path = this.parsePoly();
            return path.isEmpty();
        }
        return false;
    }
}

