/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.javascript.host.event.Event;

public class HtmlCheckBoxInput
extends HtmlInput
implements LabelableElement {
    private static final String DEFAULT_VALUE = "on";
    private boolean defaultCheckedState_;
    private boolean checkedState_;

    HtmlCheckBoxInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if (this.getAttributeDirect("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setRawValue(DEFAULT_VALUE);
        }
        this.checkedState_ = this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    @Override
    public boolean isChecked() {
        return this.checkedState_;
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    @Override
    public Page setChecked(boolean isChecked) {
        this.checkedState_ = isChecked;
        return HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        this.checkedState_ = !this.isChecked();
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return true;
    }

    @Override
    protected ScriptResult doClickFireClickEvent(Event event) {
        if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
        return super.doClickFireClickEvent(event);
    }

    @Override
    protected void doClickFireChangeEvent() {
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void preventDefault() {
        this.checkedState_ = !this.checkedState_;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValue(defaultValue);
    }

    @Override
    public void setValue(String newValue) {
        super.setValue(newValue);
        super.setDefaultValue(newValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        this.setChecked(this.isDefaultChecked());
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected Object getInternalValue() {
        return this.isChecked();
    }

    @Override
    void handleFocusLostValueChanged() {
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("checked".equals(qualifiedName)) {
            this.checkedState_ = true;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_CHECKBOX_DOES_NOT_CLICK_SURROUNDING_ANCHOR) && super.propagateClickStateUpdateToParent();
    }

    @Override
    public boolean isValueMissingValidityState() {
        return ATTRIBUTE_NOT_DEFINED != this.getAttributeDirect("required") && !this.isChecked();
    }
}

