/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import java.lang.ref.WeakReference;
import org.htmlunit.Page;

public abstract class PostponedAction {
    private final WeakReference<Page> owningPageRef_;
    private final String description_;

    public PostponedAction(Page owningPage, String description) {
        this.owningPageRef_ = new WeakReference<Page>(owningPage);
        this.description_ = description;
    }

    protected Page getOwningPage() {
        return (Page)this.owningPageRef_.get();
    }

    public abstract void execute() throws Exception;

    public boolean isStillAlive() {
        Page owningPage = this.getOwningPage();
        return owningPage != null && owningPage == owningPage.getEnclosingWindow().getEnclosedPage();
    }

    public String toString() {
        if (this.description_ == null) {
            return super.toString();
        }
        return "PostponedAction(" + this.description_ + ")";
    }
}

