/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxStaticFunction;
import org.htmlunit.javascript.configuration.JsxStaticGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.SupportedBrowser;

public abstract class AbstractJavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(AbstractJavaScriptConfiguration.class);
    private Map<Class<?>, Class<? extends HtmlUnitScriptable>> domJavaScriptMap_;
    private final Map<String, ClassConfiguration> configuration_ = new ConcurrentHashMap<String, ClassConfiguration>(this.getClasses().length);

    protected AbstractJavaScriptConfiguration(BrowserVersion browser) {
        for (Class<? extends HtmlUnitScriptable> klass : this.getClasses()) {
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass, browser);
            if (config == null) continue;
            this.configuration_.put(config.getClassName(), config);
        }
    }

    protected abstract Class<? extends HtmlUnitScriptable>[] getClasses();

    public Iterable<ClassConfiguration> getAll() {
        return this.configuration_.values();
    }

    public static ClassConfiguration getClassConfiguration(Class<? extends HtmlUnitScriptable> klass, BrowserVersion browserVersion) {
        if (browserVersion != null) {
            SupportedBrowser expectedBrowser = browserVersion.isChrome() ? SupportedBrowser.CHROME : (browserVersion.isEdge() ? SupportedBrowser.EDGE : (browserVersion.isIE() ? SupportedBrowser.IE : (browserVersion.isFirefoxESR() ? SupportedBrowser.FF_ESR : (browserVersion.isFirefox() ? SupportedBrowser.FF : SupportedBrowser.CHROME))));
            String hostClassName = klass.getName();
            JsxClasses jsxClasses = klass.getAnnotation(JsxClasses.class);
            if (jsxClasses != null) {
                if (klass.getAnnotation(JsxClass.class) != null) {
                    throw new RuntimeException("Invalid JsxClasses/JsxClass annotation; class '" + hostClassName + "' has both.");
                }
                JsxClass[] jsxClassValues = jsxClasses.value();
                if (jsxClassValues.length == 1) {
                    throw new RuntimeException("No need to specify JsxClasses with a single JsxClass for " + hostClassName);
                }
                HashSet domClasses = new HashSet();
                boolean isJsObject = false;
                String className = null;
                Class<? extends HtmlUnitScriptable> superClass = klass.getSuperclass();
                String extendedClassName = superClass == HtmlUnitScriptable.class ? "" : superClass.getSimpleName();
                for (JsxClass jsxClass : jsxClassValues) {
                    if (jsxClass == null || !AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) continue;
                    domClasses.add(jsxClass.domClass());
                    if (jsxClass.isJSObject()) {
                        isJsObject = true;
                    }
                    if (jsxClass.className().isEmpty()) continue;
                    className = jsxClass.className();
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), isJsObject, className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, expectedBrowser);
                return classConfiguration;
            }
            JsxClass jsxClass = klass.getAnnotation(JsxClass.class);
            if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) {
                Class<? extends HtmlUnitScriptable> superClass;
                String className;
                HashSet domClasses = new HashSet();
                Class<?> domClass = jsxClass.domClass();
                if (domClass != null && domClass != Object.class) {
                    domClasses.add(domClass);
                }
                if ((className = jsxClass.className()).isEmpty()) {
                    className = null;
                }
                String extendedClassName = (superClass = klass.getSuperclass()) == HtmlUnitScriptable.class ? "" : superClass.getSimpleName();
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), jsxClass.isJSObject(), className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, expectedBrowser);
                return classConfiguration;
            }
        }
        return null;
    }

    private static void process(ClassConfiguration classConfiguration, SupportedBrowser expectedBrowser) {
        ConcurrentHashMap<String, Executable> allGetters = new ConcurrentHashMap<String, Executable>();
        ConcurrentHashMap<String, Executable> allSetters = new ConcurrentHashMap<String, Executable>();
        try {
            for (Constructor<?> constructor : classConfiguration.getHostClass().getDeclaredConstructors()) {
                for (Annotation annotation : constructor.getAnnotations()) {
                    if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowser)) continue;
                    classConfiguration.setJSConstructor(constructor);
                }
            }
            for (Executable executable : classConfiguration.getHostClass().getDeclaredMethods()) {
                for (Annotation annotation : executable.getAnnotations()) {
                    String name;
                    JsxSetter jsxSetter;
                    if (annotation instanceof JsxGetter) {
                        JsxGetter jsxGetter = (JsxGetter)annotation;
                        if (AbstractJavaScriptConfiguration.isSupported(jsxGetter.value(), expectedBrowser)) {
                            Object property;
                            if (jsxGetter.propertyName().isEmpty()) {
                                int prefix = ((Method)executable).getName().startsWith("is") ? 2 : 3;
                                property = ((Method)executable).getName().substring(prefix);
                                property = Character.toLowerCase(((String)property).charAt(0)) + ((String)property).substring(1);
                            } else {
                                property = jsxGetter.propertyName();
                            }
                            allGetters.put((String)property, executable);
                        }
                    } else if (annotation instanceof JsxSetter && AbstractJavaScriptConfiguration.isSupported((jsxSetter = (JsxSetter)annotation).value(), expectedBrowser)) {
                        Object property;
                        if (jsxSetter.propertyName().isEmpty()) {
                            property = ((Method)executable).getName().substring(3);
                            property = Character.toLowerCase(((String)property).charAt(0)) + ((String)property).substring(1);
                        } else {
                            property = jsxSetter.propertyName();
                        }
                        allSetters.put((String)property, executable);
                    }
                    if (annotation instanceof JsxSymbol) {
                        JsxSymbol jsxSymbol = (JsxSymbol)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxSymbol.value(), expectedBrowser)) continue;
                        String symbolKeyName = jsxSymbol.symbolName().isEmpty() ? ((Method)executable).getName() : jsxSymbol.symbolName();
                        if (!"iterator".equalsIgnoreCase(symbolKeyName)) {
                            throw new RuntimeException("Invalid JsxSymbol annotation; unsupported '" + symbolKeyName + "' symbol name.");
                        }
                        SymbolKey symbolKey = SymbolKey.ITERATOR;
                        classConfiguration.addSymbol((Symbol)symbolKey, (Method)executable);
                        continue;
                    }
                    if (annotation instanceof JsxFunction) {
                        JsxFunction jsxFunction = (JsxFunction)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxFunction.value(), expectedBrowser)) continue;
                        name = jsxFunction.functionName().isEmpty() ? ((Method)executable).getName() : jsxFunction.functionName();
                        classConfiguration.addFunction(name, (Method)executable);
                        continue;
                    }
                    if (annotation instanceof JsxStaticGetter) {
                        JsxStaticGetter jsxStaticGetter = (JsxStaticGetter)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticGetter.value(), expectedBrowser)) continue;
                        int prefix = ((Method)executable).getName().startsWith("is") ? 2 : 3;
                        Object property = ((Method)executable).getName().substring(prefix);
                        property = Character.toLowerCase(((String)property).charAt(0)) + ((String)property).substring(1);
                        classConfiguration.addStaticProperty((String)property, (Method)executable, null);
                        continue;
                    }
                    if (annotation instanceof JsxStaticFunction) {
                        JsxStaticFunction jsxStaticFunction = (JsxStaticFunction)annotation;
                        if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticFunction.value(), expectedBrowser)) continue;
                        name = jsxStaticFunction.functionName().isEmpty() ? ((Method)executable).getName() : jsxStaticFunction.functionName();
                        classConfiguration.addStaticFunction(name, (Method)executable);
                        continue;
                    }
                    if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowser)) continue;
                    classConfiguration.setJSConstructor(executable);
                }
            }
            for (Map.Entry entry : allGetters.entrySet()) {
                String property = (String)entry.getKey();
                classConfiguration.addProperty(property, (Method)entry.getValue(), (Method)allSetters.get(property));
            }
            for (Field field : classConfiguration.getHostClass().getDeclaredFields()) {
                JsxConstant jsxConstant = field.getAnnotation(JsxConstant.class);
                if (jsxConstant == null || !AbstractJavaScriptConfiguration.isSupported(jsxConstant.value(), expectedBrowser)) continue;
                try {
                    classConfiguration.addConstant(field.getName(), field.get(null));
                }
                catch (IllegalAccessException e) {
                    throw Context.reportRuntimeError((String)("Cannot get field '" + field.getName() + "' for type: " + classConfiguration.getHostClass().getName() + "reason: " + e.getMessage()));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Processing classConfiguration for class " + classConfiguration.getHostClassSimpleName() + "failed. Reason: " + e, e);
        }
    }

    private static boolean isSupported(SupportedBrowser[] browsers, SupportedBrowser expectedBrowser) {
        for (SupportedBrowser browser : browsers) {
            if (!AbstractJavaScriptConfiguration.isCompatible(browser, expectedBrowser)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatible(SupportedBrowser browser1, SupportedBrowser browser2) {
        return browser1 == browser2;
    }

    public ClassConfiguration getClassConfiguration(String hostClassName) {
        return this.configuration_.get(hostClassName);
    }

    public Class<? extends HtmlUnitScriptable> getDomJavaScriptMappingFor(Class<?> clazz) {
        if (this.domJavaScriptMap_ == null) {
            ConcurrentHashMap map = new ConcurrentHashMap(this.configuration_.size());
            boolean debug = LOG.isDebugEnabled();
            for (Map.Entry<String, ClassConfiguration> entry : this.configuration_.entrySet()) {
                ClassConfiguration classConfig = entry.getValue();
                for (Class<?> domClass : classConfig.getDomClasses()) {
                    if (debug) {
                        LOG.debug((Object)("Mapping " + domClass.getName() + " to " + entry.getKey()));
                    }
                    map.put(domClass, classConfig.getHostClass());
                }
            }
            this.domJavaScriptMap_ = map;
        }
        return this.domJavaScriptMap_.get(clazz);
    }
}

