/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.ClientRect;

@JsxClasses(value={@JsxClass(className="DOMRectList", value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(value={SupportedBrowser.IE})})
public class ClientRectList
extends HtmlUnitScriptable {
    private final List<ClientRect> clientRects_ = new ArrayList<ClientRect>();

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ClientRectList() {
    }

    @JsxGetter
    public int getLength() {
        return this.clientRects_.size();
    }

    public final Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        return NOT_FOUND;
    }

    @JsxFunction
    public ClientRect item(int index) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTRECTLIST_THROWS_IF_ITEM_NOT_FOUND)) {
            throw Context.reportRuntimeError((String)("Invalid index '" + index + "'"));
        }
        return null;
    }

    public void add(ClientRect clientRect) {
        this.clientRects_.add(clientRect);
    }
}

