/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.w3c.dom.DOMException;

@JsxClass
public class Storage
extends HtmlUnitScriptable {
    private static final HashSet<String> RESERVED_NAMES_ = new HashSet<String>(Arrays.asList("clear", "key", "getItem", "length", "removeItem", "setItem", "constructor", "toString", "toLocaleString", "valueOf", "hasOwnProperty", "propertyIsEnumerable", "isPrototypeOf", "__defineGetter__", "__defineSetter__", "__lookupGetter__", "__lookupSetter__"));
    private static final long STORE_SIZE_KIMIT = 5200000L;
    private final Map<String, String> store_;
    private long storeSize_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Storage() {
        this.store_ = null;
    }

    public Storage(Window window, Map<String, String> store) {
        this.store_ = store;
        this.storeSize_ = 0L;
        this.setParentScope((Scriptable)window);
        this.setPrototype(window.getPrototype(Storage.class));
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        boolean isReserved = RESERVED_NAMES_.contains(name);
        if (this.store_ == null || isReserved) {
            super.put(name, start, value);
        }
        if (this.store_ != null && (!isReserved || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STORAGE_PRESERVED_INCLUDED))) {
            this.setItem(name, Context.toString((Object)value));
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.store_ == null || RESERVED_NAMES_.contains(name) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STORAGE_GET_FROM_ITEMS)) {
            return super.get(name, start);
        }
        Object value = this.getItem(name);
        if (value != null) {
            return value;
        }
        return super.get(name, start);
    }

    @JsxGetter
    public int getLength() {
        return this.store_.size();
    }

    @JsxFunction
    public void removeItem(String key) {
        String removed = this.store_.remove(key);
        if (removed != null) {
            this.storeSize_ -= (long)removed.length();
        }
    }

    @JsxFunction
    public String key(int index) {
        int counter = 0;
        for (String key : this.store_.keySet()) {
            if (counter++ != index) continue;
            return key;
        }
        return null;
    }

    @JsxFunction
    public Object getItem(String key) {
        return this.store_.get(key);
    }

    @JsxFunction
    public void setItem(String key, String data) {
        long storeSize = this.storeSize_ + (long)data.length();
        if (storeSize > 5200000L) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(22, "QuotaExceededError: Failed to execute 'setItem' on 'Storage': Setting the value of '" + key + "' exceeded the quota."));
            return;
        }
        this.storeSize_ = storeSize;
        this.store_.put(key, data);
    }

    @JsxFunction
    public void clear() {
        this.store_.clear();
        this.storeSize_ = 0L;
    }
}

