/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.nio.charset.StandardCharsets;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeUint8Array;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class TextEncoder
extends HtmlUnitScriptable {
    @JsxConstructor
    public TextEncoder() {
    }

    @JsxGetter
    public String getEncoding() {
        return "utf-8";
    }

    @JsxFunction
    public NativeUint8Array encode(Object toEncode) {
        if (Undefined.isUndefined((Object)toEncode)) {
            NativeUint8Array result = new NativeUint8Array(0);
            result.setParentScope(this.getParentScope());
            result.setPrototype(ScriptableObject.getClassPrototype((Scriptable)TextEncoder.getWindow((Scriptable)this), (String)result.getClassName()));
            return result;
        }
        String txt = toEncode == null ? "null" : Context.toString((Object)toEncode);
        byte[] bytes = txt.getBytes(StandardCharsets.UTF_8);
        NativeArrayBuffer arrayBuffer = new NativeArrayBuffer((double)bytes.length);
        System.arraycopy(bytes, 0, arrayBuffer.getBuffer(), 0, bytes.length);
        NativeUint8Array result = new NativeUint8Array(arrayBuffer, 0, bytes.length);
        result.setParentScope(this.getParentScope());
        result.setPrototype(ScriptableObject.getClassPrototype((Scriptable)TextEncoder.getWindow((Scriptable)this), (String)result.getClassName()));
        return result;
    }
}

