/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.css.CSSRule;
import org.htmlunit.javascript.host.css.CSSRuleList;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.w3c.dom.DOMException;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(isJSObject=false, value={SupportedBrowser.IE})})
public class CSSGroupingRule
extends CSSRule {
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;

    public CSSGroupingRule() {
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    protected CSSGroupingRule(CSSStyleSheet stylesheet, CSSMediaRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JsxFunction
    public int insertRule(String rule, Object position) {
        int positionInt;
        if (position == null) {
            positionInt = 0;
        } else if (Undefined.isUndefined((Object)position)) {
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GROUPINGRULE_INSERTRULE_INDEX_OPTIONAL)) throw ScriptRuntime.typeError((String)"Failed to execute 'insertRule' on 'CSSGroupingRule': 2 arguments required, but only 1 present.");
            positionInt = 0;
        } else {
            positionInt = ScriptRuntime.toInt32((Object)position);
        }
        try {
            this.initCssRules();
            this.getGroupingRule().insertRule(rule, this.fixIndex(positionInt));
            this.refreshCssRules();
            return positionInt;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos <= -1) throw Context.throwAsScriptRuntimeEx((Throwable)e);
            String newRule = rule.substring(0, pos) + "{}";
            try {
                this.getGroupingRule().insertRule(newRule, this.fixIndex(positionInt));
                this.refreshCssRules();
                return positionInt;
            }
            catch (DOMException ex) {
                throw Context.throwAsScriptRuntimeEx((Throwable)ex);
            }
        }
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.getGroupingRule().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = this.getGroupingRule().getCssRules();
        List rules = ruleList.getRules();
        int pos = 0;
        for (AbstractCSSRuleImpl rule : rules) {
            if (rule instanceof CSSCharsetRuleImpl) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this.getParentStyleSheet(), rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
    }

    private CSSMediaRuleImpl getGroupingRule() {
        return (CSSMediaRuleImpl)this.getRule();
    }
}

