/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;

@JsxClass
public class DOMException
extends HtmlUnitScriptable {
    @JsxConstant
    public static final short DOMSTRING_SIZE_ERR = 2;
    @JsxConstant
    public static final short HIERARCHY_REQUEST_ERR = 3;
    @JsxConstant
    public static final short INDEX_SIZE_ERR = 1;
    @JsxConstant
    public static final short INUSE_ATTRIBUTE_ERR = 10;
    @JsxConstant
    public static final short INVALID_ACCESS_ERR = 15;
    @JsxConstant
    public static final short INVALID_CHARACTER_ERR = 5;
    @JsxConstant
    public static final short INVALID_MODIFICATION_ERR = 13;
    @JsxConstant
    public static final short INVALID_STATE_ERR = 11;
    @JsxConstant
    public static final short NAMESPACE_ERR = 14;
    @JsxConstant
    public static final short NO_DATA_ALLOWED_ERR = 6;
    @JsxConstant
    public static final short NO_MODIFICATION_ALLOWED_ERR = 7;
    @JsxConstant
    public static final short NOT_FOUND_ERR = 8;
    @JsxConstant
    public static final short NOT_SUPPORTED_ERR = 9;
    @JsxConstant
    public static final short SYNTAX_ERR = 12;
    @JsxConstant
    public static final short WRONG_DOCUMENT_ERR = 4;
    @JsxConstant
    public static final short VALIDATION_ERR = 16;
    @JsxConstant
    public static final short TYPE_MISMATCH_ERR = 17;
    @JsxConstant
    public static final short SECURITY_ERR = 18;
    @JsxConstant
    public static final short NETWORK_ERR = 19;
    @JsxConstant
    public static final short ABORT_ERR = 20;
    @JsxConstant
    public static final short URL_MISMATCH_ERR = 21;
    @JsxConstant
    public static final short QUOTA_EXCEEDED_ERR = 22;
    @JsxConstant
    public static final short TIMEOUT_ERR = 23;
    @JsxConstant
    public static final short INVALID_NODE_TYPE_ERR = 24;
    @JsxConstant
    public static final short DATA_CLONE_ERR = 25;
    @JsxConstant(value={SupportedBrowser.IE})
    public static final short PARSE_ERR = 81;
    @JsxConstant(value={SupportedBrowser.IE})
    public static final short SERIALIZE_ERR = 82;
    private final short code_;
    private final String message_;
    private int lineNumber_;
    private String fileName_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMException() {
        this.code_ = (short)-1;
        this.message_ = null;
    }

    public DOMException(String message, short errorCode) {
        this.code_ = errorCode;
        this.message_ = message;
    }

    @JsxGetter
    public Object getCode() {
        if (this.code_ == -1) {
            return Undefined.instance;
        }
        return this.code_;
    }

    @JsxGetter
    public Object getMessage() {
        if (this.message_ == null) {
            return Undefined.instance;
        }
        return this.message_;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getLineNumber() {
        if (this.lineNumber_ == -1) {
            return Undefined.instance;
        }
        return this.lineNumber_;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getFilename() {
        if (this.fileName_ == null) {
            return Undefined.instance;
        }
        return this.fileName_;
    }

    public void setLocation(String fileName, int lineNumber) {
        this.fileName_ = fileName;
        this.lineNumber_ = lineNumber;
    }
}

