/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.geo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.geo.Coordinates;
import org.htmlunit.javascript.host.geo.Position;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR, SupportedBrowser.IE})
public class Geolocation
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(Geolocation.class);
    private static String PROVIDER_URL_ = "https://maps.googleapis.com/maps/api/browserlocation/json";
    private Function successHandler_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Geolocation() {
    }

    @JsxFunction
    public void getCurrentPosition(Function successCallback, Object errorCallback, Object options) {
        this.successHandler_ = successCallback;
        WebWindow webWindow = this.getWindow().getWebWindow();
        if (webWindow.getWebClient().getOptions().isGeolocationEnabled()) {
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(0, null, () -> this.doGetPosition());
            webWindow.getJobManager().addJob(job, webWindow.getEnclosedPage());
        }
    }

    @JsxFunction
    public int watchPosition(Function successCallback, Object errorCallback, Object options) {
        return 0;
    }

    @JsxFunction
    public void clearWatch(int watchId) {
    }

    void doGetPosition() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String wifiStringString = null;
        if (os.contains("win")) {
            wifiStringString = Geolocation.getWifiStringWindows();
        }
        if (wifiStringString == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Operating System not supported: " + os));
            }
        } else {
            Object url = PROVIDER_URL_;
            url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
            url = (String)url + "browser=firefox&sensor=true";
            url = (String)url + wifiStringString;
            while (((String)url).length() >= 1900) {
                url = ((String)url).substring(0, ((String)url).lastIndexOf("&wifi="));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Invoking URL: " + (String)url));
            }
            try (WebClient webClient = new WebClient(BrowserVersion.FIREFOX);){
                Object page = webClient.getPage((String)url);
                String content = page.getWebResponse().getContentAsString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Receieved Content: " + content));
                }
                double latitude = Double.parseDouble(Geolocation.getJSONValue(content, "lat"));
                double longitude = Double.parseDouble(Geolocation.getJSONValue(content, "lng"));
                double accuracy = Double.parseDouble(Geolocation.getJSONValue(content, "accuracy"));
                Coordinates coordinates = new Coordinates(latitude, longitude, accuracy);
                coordinates.setPrototype(this.getPrototype(coordinates.getClass()));
                Position position = new Position(coordinates);
                position.setPrototype(this.getPrototype(position.getClass()));
                WebWindow ww = this.getWindow().getWebWindow();
                JavaScriptEngine jsEngine = (JavaScriptEngine)ww.getWebClient().getJavaScriptEngine();
                jsEngine.callFunction((HtmlPage)ww.getEnclosedPage(), this.successHandler_, (Scriptable)this, this.getParentScope(), new Object[]{position});
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
    }

    private static String getJSONValue(String content, String key) {
        char ch;
        StringBuilder builder = new StringBuilder();
        int index = content.indexOf("\"" + key + "\"") + key.length() + 2;
        for (index = content.indexOf(58, index) + 1; index < content.length() && (ch = content.charAt(index)) != ',' && ch != '}'; ++index) {
            builder.append(ch);
        }
        return builder.toString().trim();
    }

    static String getWifiStringWindows() {
        StringBuilder builder = new StringBuilder();
        try {
            List<String> lines = Geolocation.runCommand("netsh wlan show networks mode=bssid");
            Iterator<String> it = lines.iterator();
            block2: while (it.hasNext()) {
                String line = it.next();
                if (!line.startsWith("SSID ")) continue;
                String name = line.substring(line.lastIndexOf(32) + 1);
                if (it.hasNext()) {
                    it.next();
                }
                if (it.hasNext()) {
                    it.next();
                }
                if (it.hasNext()) {
                    it.next();
                }
                while (it.hasNext()) {
                    line = it.next();
                    if (line.trim().startsWith("BSSID ")) {
                        String mac = line.substring(line.lastIndexOf(32) + 1);
                        if (it.hasNext() && (line = it.next().trim()).startsWith("Signal")) {
                            String signal = line.substring(line.lastIndexOf(32) + 1, line.length() - 1);
                            int signalStrength = Integer.parseInt(signal) / 2 - 100;
                            builder.append("&wifi=mac:").append(mac.replace(':', '-')).append("%7Cssid:").append(name).append("%7Css:").append(signalStrength);
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)line)) continue;
                    continue block2;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    private static List<String> runCommand(String command) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec(command);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    static void setProviderUrl(String url) {
        PROVIDER_URL_ = url;
    }
}

