/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.util.UrlUtils;

@JsxClass(domClass=HtmlAnchor.class)
public class HTMLAnchorElement
extends HTMLElement {
    private static final List<String> REFERRER_POLICIES = Arrays.asList("no-referrer", "origin", "unsafe-url");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLAnchorElement() {
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == hrefAttr) {
            return "";
        }
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return hrefAttr;
        }
    }

    @Override
    public void focus() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != hrefAttr) {
            anchor.focus();
        }
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttributeDirect("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getDomNodeOrDie().setAttribute("href", url.toString());
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getReferrerPolicy() {
        String attrib = this.getDomNodeOrDie().getAttribute("referrerPolicy");
        if (StringUtils.isEmpty((CharSequence)attrib)) {
            return "";
        }
        if (REFERRER_POLICIES.contains(attrib = attrib.toLowerCase(Locale.ROOT))) {
            return attrib;
        }
        return "";
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setReferrerPolicy(String referrerPolicy) {
        this.getDomNodeOrDie().setAttribute("referrerPolicy", referrerPolicy);
    }

    @JsxGetter
    public String getSearch() {
        try {
            String query = this.getUrl().getQuery();
            if (query == null) {
                return "";
            }
            return "?" + query;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    @JsxGetter
    public String getHash() {
        try {
            String hash = this.getUrl().getRef();
            if (hash == null) {
                return "";
            }
            return "#" + hash;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    @JsxGetter
    public String getHost() {
        try {
            URL url = this.getUrl();
            int port = url.getPort();
            String host = url.getHost();
            if (port == -1) {
                return host;
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getHostname() {
        try {
            return UrlUtils.encodeAnchor(this.getUrl().getHost());
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_HOSTNAME_IGNORE_BLANK)) {
            if (!StringUtils.isBlank((CharSequence)hostname)) {
                this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
            }
        } else if (!StringUtils.isEmpty((CharSequence)hostname)) {
            this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
        }
    }

    @JsxGetter
    public String getPathname() {
        try {
            HtmlAnchor anchor;
            Object href;
            URL url = this.getUrl();
            if (!url.getProtocol().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_NONE_HTTP_URL)) {
                return "";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && ((String)(href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute())).length() > 1 && Character.isLetter(((String)href).charAt(0)) && ':' == ((String)href).charAt(1)) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_UPPER_CASE_DRIVE_LETTERS)) {
                    href = StringUtils.capitalize((String)href);
                }
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_PREFIX_WIN_DRIVES_URL)) {
                    href = "/" + (String)href;
                }
                return href;
            }
            return url.getPath();
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_BROKEN_URL)) {
                return "";
            }
            return "/";
        }
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() {
        try {
            int port = this.getUrl().getPort();
            if (port == -1) {
                return "";
            }
            return Integer.toString(port);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() {
        BrowserVersion browser = this.getBrowserVersion();
        try {
            HtmlAnchor anchor;
            String href;
            if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute().toLowerCase(Locale.ROOT)).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
                return "file:";
            }
            return this.getUrl().getProtocol() + ":";
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http")) {
                if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_FOR_BROKEN_URL)) {
                    return ":";
                }
                if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_HTTP_FOR_BROKEN_URL)) {
                    return "http:";
                }
            }
            return StringUtils.substringBefore((String)anchor.getHrefAttribute(), (String)"/");
        }
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        String bareProtocol = StringUtils.substringBefore((String)protocol, (String)":");
        if (UrlUtils.isValidScheme(bareProtocol)) {
            this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol));
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_INVALID_THROWS)) {
            throw ScriptRuntime.typeError((String)("Invalid protocol '" + protocol + "'."));
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    static String getDefaultValue(HtmlElement element) {
        String href = element.getAttributeDirect("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            return "";
        }
        href = href.trim();
        SgmlPage page = element.getPage();
        if (page == null || !page.isHtmlPage()) {
            return href;
        }
        try {
            return HtmlAnchor.getTargetUrl(href, (HtmlPage)page).toExternalForm();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        return htmlElement.asNormalizedText();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.setTextContent(text);
    }

    @JsxGetter
    public String getCharset() {
        return this.getDomNodeOrDie().getAttributeDirect("charset");
    }

    @JsxSetter
    public void setCharset(String charset) {
        this.getDomNodeOrDie().setAttribute("charset", charset);
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttributeDirect("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }

    @JsxGetter
    public String getHreflang() {
        return this.getDomNodeOrDie().getAttributeDirect("hreflang");
    }

    @JsxSetter
    public void setHreflang(String hreflang) {
        this.getDomNodeOrDie().setAttribute("hreflang", hreflang);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getOrigin() {
        if (!this.getDomNodeOrDie().hasAttribute("href")) {
            return "";
        }
        try {
            return this.getUrl().getProtocol() + "://" + this.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOrigin(String origin) {
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getUsername() {
        try {
            String userInfo = this.getUrl().getUserInfo();
            if (userInfo == null) {
                return "";
            }
            return StringUtils.substringBefore((String)userInfo, (int)58);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setUsername(String username) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserName(url, username));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getPassword() {
        try {
            String userName = this.getUrl().getUserInfo();
            if (userName == null) {
                return "";
            }
            return StringUtils.substringAfter((String)userName, (String)":");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setPassword(String password) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserPassword(url, password));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getDownload() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getDownloadAttribute();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setDownload(String download) {
        this.getDomNodeOrDie().setAttribute("download", download);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getPing() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getPingAttribute();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setPing(String ping) {
        this.getDomNodeOrDie().setAttribute("ping", ping);
    }

    @JsxGetter
    public String getShape() {
        return this.getDomNodeOrDie().getAttribute("shape");
    }

    @JsxSetter
    public void setShape(String shape) {
        this.getDomNodeOrDie().setAttribute("shape", shape);
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttributeDirect("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getProtocolLong() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(propertyName="Methods", value={SupportedBrowser.IE})
    public String getMethods_js() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(propertyName="Methods", value={SupportedBrowser.IE})
    public void setMethods_js(String methods) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getMimeType() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setMimeType(String mimeType) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getNameProp() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getUrn() {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setUrn(String urn) {
        throw Context.throwAsScriptRuntimeEx((Throwable)new UnsupportedOperationException());
    }
}

