/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.regexp;

import com.xceptance.common.collection.ConcurrentLRUCache;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.RegExpProxy;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.regexp.NativeRegExp;
import org.htmlunit.corejs.javascript.regexp.RegExpImpl;
import org.htmlunit.corejs.javascript.regexp.SubString;
import org.htmlunit.javascript.regexp.RegExpJsToJavaConverter;

public class HtmlUnitRegExpProxy
extends RegExpImpl {
    private static final Log LOG = LogFactory.getLog(HtmlUnitRegExpProxy.class);
    private static final ConcurrentLRUCache<String, Pattern> PATTENS = new ConcurrentLRUCache(1001);
    private final RegExpProxy wrapped_;
    private final BrowserVersion browserVersion_;

    public HtmlUnitRegExpProxy(RegExpProxy wrapped, BrowserVersion browserVersion) {
        this.wrapped_ = wrapped;
        this.browserVersion_ = browserVersion;
    }

    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            return this.doAction(cx, scope, thisObj, args, actionType);
        }
        catch (RegExStickyNotSupportedException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return this.wrapped_.action(cx, scope, thisObj, args, actionType);
        }
        catch (StackOverflowError e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return this.wrapped_.action(cx, scope, thisObj, args, actionType);
        }
    }

    private Object doAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        if (2 == actionType && args.length == 2 && args[1] instanceof String) {
            String thisString = Context.toString((Object)thisObj);
            String replacement = (String)args[1];
            Object arg0 = args[0];
            if (arg0 instanceof String) {
                return this.doStringReplacement(thisString, (String)arg0, replacement);
            }
            if (arg0 instanceof NativeRegExp) {
                try {
                    NativeRegExp regexp = (NativeRegExp)arg0;
                    RegExpData reData = new RegExpData(regexp);
                    Matcher matcher = reData.getPattern().matcher(thisString);
                    return this.doReplacement(thisString, replacement, matcher, reData.isGlobal());
                }
                catch (PatternSyntaxException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (1 == actionType || 3 == actionType) {
            if (args.length == 0) {
                return null;
            }
            Object arg0 = args[0];
            String thisString = Context.toString((Object)thisObj);
            RegExpData reData = arg0 instanceof NativeRegExp ? new RegExpData((NativeRegExp)arg0) : new RegExpData(Context.toString((Object)arg0));
            Matcher matcher = reData.getPattern().matcher(thisString);
            boolean found = matcher.find();
            if (3 == actionType) {
                if (found) {
                    this.setProperties(matcher, thisString, matcher.start(), matcher.end());
                    return matcher.start();
                }
                return -1;
            }
            if (!found) {
                return null;
            }
            int index = matcher.start(0);
            ArrayList<Object> groups = new ArrayList<Object>();
            if (reData.isGlobal()) {
                groups.add(matcher.group(0));
                this.setProperties(matcher, thisString, matcher.start(0), matcher.end(0));
                while (matcher.find()) {
                    groups.add(matcher.group(0));
                    this.setProperties(matcher, thisString, matcher.start(0), matcher.end(0));
                }
            } else {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    Object group = matcher.group(i);
                    if (group == null) {
                        group = Undefined.instance;
                    }
                    groups.add(group);
                }
                this.setProperties(matcher, thisString, matcher.start(), matcher.end());
            }
            Scriptable response = cx.newArray(scope, groups.toArray());
            response.put("index", response, (Object)index);
            response.put("input", response, (Object)thisString);
            return response;
        }
        return this.wrappedAction(cx, scope, thisObj, args, actionType);
    }

    private String doStringReplacement(String originalString, String searchString, String replacement) {
        if (originalString == null) {
            return "";
        }
        StaticStringMatcher matcher = new StaticStringMatcher(originalString, searchString);
        if (matcher.start() > -1) {
            StringBuilder sb = new StringBuilder().append(originalString, 0, matcher.start_);
            String localReplacement = replacement;
            if (replacement.contains("$")) {
                localReplacement = this.computeReplacementValue(localReplacement, originalString, matcher, false);
            }
            sb.append(localReplacement).append(originalString, matcher.end_, originalString.length());
            return sb.toString();
        }
        return originalString;
    }

    private String doReplacement(String originalString, String replacement, Matcher matcher, boolean replaceAll) {
        StringBuilder sb = new StringBuilder();
        int previousIndex = 0;
        while (matcher.find()) {
            sb.append(originalString, previousIndex, matcher.start());
            String localReplacement = replacement;
            if (replacement.contains("$")) {
                localReplacement = this.computeReplacementValue(replacement, originalString, matcher, this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_REGEXP_GROUP0_RETURNS_WHOLE_MATCH));
            }
            sb.append(localReplacement);
            previousIndex = matcher.end();
            this.setProperties(matcher, originalString, matcher.start(), previousIndex);
            if (replaceAll) continue;
            break;
        }
        sb.append(originalString, previousIndex, originalString.length());
        return sb.toString();
    }

    String computeReplacementValue(String replacement, String originalString, MatchResult matcher, boolean group0ReturnsWholeMatch) {
        int i;
        int lastIndex = 0;
        StringBuilder result = new StringBuilder();
        while ((i = replacement.indexOf(36, lastIndex)) > -1) {
            if (i > 0) {
                result.append(replacement, lastIndex, i);
            }
            String ss = null;
            if (i < replacement.length() - 1 && (i == lastIndex || replacement.charAt(i - 1) != '$')) {
                char next = replacement.charAt(i + 1);
                if (next >= '1' && next <= '9') {
                    int num1digit = next - 48;
                    int next2 = i + 2 < replacement.length() ? (int)replacement.charAt(i + 2) : 120;
                    int num2digits = next2 >= 49 && next2 <= 57 ? num1digit * 10 + (next2 - 48) : Integer.MAX_VALUE;
                    if (num2digits <= matcher.groupCount()) {
                        ss = matcher.group(num2digits);
                        ++i;
                    } else if (num1digit <= matcher.groupCount()) {
                        ss = StringUtils.defaultString((String)matcher.group(num1digit));
                    }
                } else {
                    switch (next) {
                        case '&': {
                            ss = matcher.group();
                            break;
                        }
                        case '0': {
                            if (!group0ReturnsWholeMatch) break;
                            ss = matcher.group();
                            break;
                        }
                        case '`': {
                            ss = originalString.substring(0, matcher.start());
                            break;
                        }
                        case '\'': {
                            ss = originalString.substring(matcher.end());
                            break;
                        }
                        case '$': {
                            ss = "$";
                            break;
                        }
                    }
                }
            }
            if (ss == null) {
                result.append('$');
                lastIndex = i + 1;
                continue;
            }
            result.append(ss);
            lastIndex = i + 2;
        }
        result.append(replacement, lastIndex, replacement.length());
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object wrappedAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this.wrapped_);
            Object object = this.wrapped_.action(cx, scope, thisObj, args, actionType);
            return object;
        }
        finally {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this);
        }
    }

    private void setProperties(Matcher matcher, String thisString, int startPos, int endPos) {
        String match = matcher.group();
        this.lastMatch = match == null ? new SubString() : new SubString(match, 0, match.length());
        int groupCount = matcher.groupCount();
        if (groupCount == 0) {
            this.parens = null;
        } else {
            int count = Math.min(9, groupCount);
            this.parens = new SubString[count];
            for (int i = 0; i < count; ++i) {
                String group = matcher.group(i + 1);
                this.parens[i] = group == null ? new SubString() : new SubString(group, 0, group.length());
            }
        }
        if (groupCount > 0) {
            String last;
            this.lastParen = groupCount > 9 && this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_REGEXP_EMPTY_LASTPAREN_IF_TOO_MANY_GROUPS) ? new SubString() : ((last = matcher.group(groupCount)) == null ? new SubString() : new SubString(last, 0, last.length()));
        }
        this.leftContext = startPos > 0 ? new SubString(thisString, 0, startPos) : new SubString();
        int length = thisString.length();
        this.rightContext = endPos < length ? new SubString(thisString, endPos, length - endPos) : new SubString();
    }

    public Object compileRegExp(Context cx, String source, String flags) {
        try {
            return this.wrapped_.compileRegExp(cx, source, flags);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("compileRegExp() threw for >" + source + "<, flags: >" + flags + "<. Replacing with a '####shouldNotFindAnything###'"));
            }
            return this.wrapped_.compileRegExp(cx, "####shouldNotFindAnything###", "");
        }
    }

    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        return this.wrapped_.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
    }

    public boolean isRegExp(Scriptable obj) {
        return this.wrapped_.isRegExp(obj);
    }

    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return this.wrapped_.wrapRegExp(cx, scope, compiled);
    }

    static String jsRegExpToJavaRegExp(String re) {
        RegExpJsToJavaConverter regExpJsToJavaFSM = new RegExpJsToJavaConverter();
        return regExpJsToJavaFSM.convert(re);
    }

    private static class RegExStickyNotSupportedException
    extends IllegalArgumentException {
        RegExStickyNotSupportedException(String regex) {
            super("RegEx sticky flag is not supported (" + regex + ") by HtmlUnitRegExProxy");
        }
    }

    private static final class StaticStringMatcher
    implements MatchResult {
        private final String group_;
        private final int start_;
        private final int end_;

        StaticStringMatcher(String originalString, String searchString) {
            int pos = originalString.indexOf(searchString);
            this.group_ = searchString;
            this.start_ = pos;
            this.end_ = pos + searchString.length();
        }

        @Override
        public String group() {
            return this.group_;
        }

        @Override
        public int start() {
            return this.start_;
        }

        @Override
        public int end() {
            return this.end_;
        }

        @Override
        public int start(int group) {
            return 0;
        }

        @Override
        public int end(int group) {
            return 0;
        }

        @Override
        public String group(int group) {
            return null;
        }

        @Override
        public int groupCount() {
            return 0;
        }
    }

    private static class RegExpData {
        private final boolean global_;
        private Pattern pattern_;

        RegExpData(NativeRegExp re) {
            String str = re.toString();
            String jsFlags = StringUtils.substringAfterLast((String)str, (String)"/");
            if (jsFlags.indexOf(121) != -1) {
                throw new RegExStickyNotSupportedException(str);
            }
            this.global_ = jsFlags.indexOf(103) != -1;
            this.pattern_ = PATTENS.get(str);
            if (this.pattern_ == null) {
                String jsSource = StringUtils.substringBeforeLast((String)str.substring(1), (String)"/");
                this.pattern_ = Pattern.compile(HtmlUnitRegExpProxy.jsRegExpToJavaRegExp(jsSource), RegExpData.getJavaFlags(jsFlags));
                PATTENS.put(str, this.pattern_);
            }
        }

        RegExpData(String string) {
            this.global_ = false;
            this.pattern_ = PATTENS.get(string);
            if (this.pattern_ == null) {
                this.pattern_ = Pattern.compile(HtmlUnitRegExpProxy.jsRegExpToJavaRegExp(string), 0);
                PATTENS.put(string, this.pattern_);
            }
        }

        private static int getJavaFlags(String jsFlags) {
            int flags = 0;
            if (jsFlags.contains("i")) {
                flags |= 2;
            }
            if (jsFlags.contains("m")) {
                flags |= 8;
            }
            return flags;
        }

        boolean isGlobal() {
            return this.global_;
        }

        Pattern getPattern() {
            return this.pattern_;
        }
    }
}

