/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util.zip;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.common.XltConstants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static void zipDirectory(File directory, File zipFile) throws IOException {
        ZipUtils.zipDirectory(directory, null, zipFile);
    }

    public static void zipDirectory(File directory, FileFilter fileFilter, File zipFile) throws IOException {
        ZipUtils.zipDirectory(directory, fileFilter, zipFile, true);
    }

    public static ZipOutputStream zipDirectory(File directory, FileFilter fileFilter, File zipFile, boolean closeStream) throws IOException {
        return ZipUtils.zipDirectory(directory, fileFilter, zipFile, new File("."), closeStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZipOutputStream zipDirectory(File directory, FileFilter fileFilter, File zipFile, File relDir, boolean closeStream) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException("The target file must not be null.");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipUtils.zipDirectory(out, directory, fileFilter, relDir);
            if (!closeStream) return out;
        }
        catch (Throwable throwable) {
            if (!closeStream) throw throwable;
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return out;
    }

    private static void checkDirectory(File directory) throws IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException("The directory parameter must not be null.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directory);
        }
    }

    public static void zipDirectory(ZipOutputStream out, File directory, FileFilter fileFilter, File relDir) throws IOException {
        ZipUtils.checkDirectory(directory);
        if (out == null) {
            throw new IllegalArgumentException("The target output stream must not be null!");
        }
        log.debug("Start zipping files");
        ZipUtils.addDir(directory, fileFilter, relDir, out);
        log.debug("Finished zipping files");
        out.flush();
    }

    private static void addDir(File dir, FileFilter fileFilter, File relDir, ZipOutputStream out) throws IOException {
        File[] files = dir.listFiles(fileFilter);
        if (files != null) {
            for (File file : files) {
                File relFile = new File(relDir, file.getName());
                String relFileName = relFile.toString().replace('\\', '/');
                if (file.isDirectory()) {
                    ZipUtils.addDirectoryEntry(out, relFileName);
                    ZipUtils.addDir(file, fileFilter, relFile, out);
                    continue;
                }
                ZipUtils.addRegularFile(out, file, relFileName);
            }
        }
    }

    public static void addDirectoryEntry(ZipOutputStream out, String relFileName) throws IOException {
        log.debug("Adding directory to ZIP: " + relFileName);
        out.putNextEntry(new ZipEntry(relFileName + "/"));
        out.closeEntry();
    }

    public static void addRegularFile(ZipOutputStream out, File file, String relFileName) throws FileNotFoundException, IOException {
        log.debug("Adding file to ZIP: " + relFileName);
        out.putNextEntry(new ZipEntry(relFileName));
        FileUtils.copyFile((File)file, (OutputStream)out);
        out.closeEntry();
    }

    public static void unzipFile(File zipFile, File directory) throws IOException {
        ZipUtils.unzipFile(zipFile, directory, false);
    }

    public static void unzipFile(File zipFile, File directory, boolean compressedTimerFiles) throws IOException {
        ParameterCheckUtils.isReadableFile(zipFile, "zipFile");
        ParameterCheckUtils.isNotNull(directory, "directory");
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                File file = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir((File)file);
                } else {
                    File compressedFile = null;
                    boolean compressIt = false;
                    if (compressedTimerFiles) {
                        String fileName = file.getName();
                        boolean b1 = XltConstants.TIMER_FILENAME_PATTERNS.stream().anyMatch(p -> p.asPredicate().test(fileName));
                        boolean b2 = XltConstants.CPT_TIMER_FILENAME_PATTERNS.stream().anyMatch(p -> p.asPredicate().test(fileName));
                        if (b1 || b2) {
                            compressedFile = new File(directory, entry.getName() + ".gz");
                            compressIt = true;
                        }
                    }
                    try (OutputStream out = compressIt ? new GZIPOutputStream(new FileOutputStream(compressedFile)) : new FileOutputStream(file);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                }
                in.closeEntry();
            }
        }
    }
}

