/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.xlt.agentcontroller.PartialGetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = -4559286002497439251L;
    private static final Logger log = LoggerFactory.getLogger(FileManagerServlet.class);
    static final String SERVLET_PATH = "/fileManager/";
    static final String SERVLET_MAPPING = "/fileManager/*";
    private final File rootDirectory;

    public FileManagerServlet(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FileInputStream in = null;
        String fileName = this.getFileName(req);
        try {
            log.debug("File being downloaded: " + fileName);
            if (fileName == null) {
                resp.setStatus(400);
                return;
            }
            File file = new File(this.rootDirectory, fileName);
            if (!file.isFile()) {
                resp.setStatus(404);
                return;
            }
            long fileLength = file.length();
            if (fileLength == 0L) {
                resp.setStatus(200);
                resp.setContentLengthLong(0L);
                IOUtils.closeQuietly((InputStream)in);
                return;
            }
            in = new FileInputStream(file);
            String rangeHeaderValue = req.getHeader("Range");
            if (rangeHeaderValue == null) {
                log.debug("Serving full content from file '{}' ...", (Object)file);
                resp.setStatus(200);
                resp.setContentLengthLong(fileLength);
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            } else {
                PartialGetUtils.RangeHeaderData rangeHeaderData = PartialGetUtils.parseRangeHeader(rangeHeaderValue);
                if (rangeHeaderData == null) {
                    resp.setStatus(400);
                    IOUtils.closeQuietly((InputStream)in);
                    return;
                }
                long startPos = rangeHeaderData.startPos;
                long endPos = rangeHeaderData.endPos;
                if (startPos > endPos || startPos > fileLength - 1L) {
                    resp.setStatus(416);
                    IOUtils.closeQuietly((InputStream)in);
                    return;
                }
                long finalEndPos = Math.min(endPos, fileLength - 1L);
                long bytes = finalEndPos - startPos + 1L;
                String contentRangeHeaderValue = PartialGetUtils.formatContentRangeHeader(startPos, finalEndPos, fileLength);
                log.debug("Serving chunk {}-{} from file '{}' ...", new Object[]{startPos, endPos, file});
                resp.setStatus(206);
                resp.setContentLengthLong(bytes);
                resp.setHeader("Content-Range", contentRangeHeaderValue);
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)startPos, (long)bytes);
            }
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
        catch (Exception ex) {
            log.error("Error while file is downloaded: " + fileName, (Throwable)ex);
            resp.setStatus(500);
            return;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        FileOutputStream out = null;
        String fileName = this.getFileName(req);
        try {
            log.debug("File being uploaded: " + fileName);
            if (fileName == null) {
                resp.setStatus(400);
            } else {
                File file = new File(this.rootDirectory, fileName);
                out = new FileOutputStream(file);
                ServletInputStream in = req.getInputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                resp.setStatus(200);
            }
        }
        catch (Exception ex) {
            log.error("Error while file is uploaded: " + fileName, (Throwable)ex);
            resp.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private String getFileName(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return null;
        }
        if (pathInfo.charAt(0) == '/') {
            if (pathInfo.length() == 1) {
                return null;
            }
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }
}

