/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.report;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.PostProcessedDataContainer;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractReportProvider
implements ReportProvider {
    private ReportProviderConfiguration configuration;
    private final ReentrantLock lock = new ReentrantLock(true);

    public ReportProviderConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        this.configuration = config;
    }

    @Override
    public boolean lock() {
        return this.lock.tryLock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void processAll(PostProcessedDataContainer dataContainer) {
        Data d;
        List<Data> data = dataContainer.data;
        int size = data.size();
        int sampleFactor = dataContainer.sampleFactor;
        int droppedLines = dataContainer.droppedLines;
        for (int p = 0; p < size; ++p) {
            d = data.get(p);
            this.processDataRecord(d);
        }
        if (droppedLines > 0) {
            for (int i = 0; i < size; ++i) {
                d = data.get(i);
                if (d instanceof TransactionData) continue;
                for (int y = 1; y < sampleFactor; ++y) {
                    this.processDataRecord(d);
                }
                if (--droppedLines == 0) break;
            }
        }
    }
}

