/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.BasicPageUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.htmlunit.html.DefaultElementFactory;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSelect;
import org.junit.Assert;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlPageUtils
extends BasicPageUtils {
    public static void checkRadioButton(HtmlForm form, String radioButtonName, int index) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(radioButtonName, "radioButtonName");
        ParameterCheckUtils.isNotNegative(index, "index");
        List<HtmlRadioButtonInput> buttons = form.getRadioButtonsByName(radioButtonName);
        Assert.assertTrue((String)("No radio buttons found for name: " + radioButtonName), (!buttons.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Radio button index too large: " + index), (index < buttons.size() ? 1 : 0) != 0);
        buttons.get(index).setChecked(true);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Checking radio button: %s.%s", HtmlPageUtils.getIdOrName(form), radioButtonName));
        }
    }

    public static void checkRadioButton(HtmlForm form, String radioButtonName, String value) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(radioButtonName, "radioButtonName");
        ParameterCheckUtils.isNotNullOrEmpty(value, "value");
        HtmlRadioButtonInput theRadioButton = null;
        List<HtmlRadioButtonInput> radioButtons = form.getRadioButtonsByName(radioButtonName);
        for (HtmlRadioButtonInput radioButton : radioButtons) {
            if (!value.equals(radioButton.getValue())) continue;
            theRadioButton = radioButton;
            break;
        }
        Assert.assertNotNull((String)String.format("No radio button input element found with name='%s' and value='%s'", radioButtonName, value), (Object)theRadioButton);
        theRadioButton.setChecked(true);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Checking radio button: %s.%s", HtmlPageUtils.getIdOrName(form), radioButtonName));
        }
    }

    public static void checkRadioButtonRandomly(HtmlForm form, String radioButtonName) {
        HtmlPageUtils.checkRadioButtonRandomly(form, radioButtonName, false, false);
    }

    public static void checkRadioButtonRandomly(HtmlForm form, String radioButtonName, boolean excludeFirst, boolean excludeLast) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(radioButtonName, "radioButtonName");
        List<HtmlRadioButtonInput> buttons = form.getRadioButtonsByName(radioButtonName);
        Assert.assertTrue((String)("No radio buttons found for name: " + radioButtonName), (!buttons.isEmpty() ? 1 : 0) != 0);
        HtmlRadioButtonInput button = HtmlPageUtils.pickOneRandomly(buttons, excludeFirst, excludeLast);
        button.setChecked(true);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Checking radio button: %s.%s", HtmlPageUtils.getIdOrName(form), HtmlPageUtils.getIdOrName(button)));
        }
    }

    public static <T extends HtmlElement> T createHtmlElement(String tagName, HtmlElement parent) {
        ParameterCheckUtils.isNotNullOrEmpty(tagName, "tagName");
        ParameterCheckUtils.isNotNull(parent, "parent");
        HtmlElement element = (HtmlElement)((HtmlPage)parent.getPage()).createElement(tagName);
        parent.appendChild(element);
        return (T)element;
    }

    public static HtmlInput createInput(HtmlForm form, String type, String name, String value) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(type, "type");
        ParameterCheckUtils.isNotNullOrEmpty(name, "name");
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(null, "name", "name", "", name);
        attributes.addAttribute(null, "type", "type", "", type);
        attributes.addAttribute(null, "value", "value", "", value);
        HtmlElement input = new DefaultElementFactory().createElement(form.getPage(), "input", attributes);
        form.appendChild(input);
        return (HtmlInput)input;
    }

    public static <T extends HtmlElement> List<T> findHtmlElements(HtmlPage page, String xpath) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(xpath, "xpath");
        List elements = page.getByXPath(xpath);
        Assert.assertTrue((String)("No elements found for XPath: " + xpath), (!elements.isEmpty() ? 1 : 0) != 0);
        return elements;
    }

    public static <T> T findHtmlElementsAndPickOne(HtmlPage page, String xpath) {
        return HtmlPageUtils.findHtmlElementsAndPickOne(page, xpath, false, false);
    }

    public static <T> T findHtmlElementsAndPickOne(HtmlPage page, String xpath, boolean excludeFirst) {
        return HtmlPageUtils.findHtmlElementsAndPickOne(page, xpath, excludeFirst, false);
    }

    public static <T extends HtmlElement> T findHtmlElementsAndPickOne(HtmlPage page, String xpath, boolean excludeFirst, boolean excludeLast) {
        List<T> elements = HtmlPageUtils.findHtmlElements(page, xpath);
        return (T)((HtmlElement)HtmlPageUtils.pickOneRandomly(elements, excludeFirst, excludeLast));
    }

    public static <T extends HtmlElement> T findSingleHtmlElementByID(HtmlPage page, String id) {
        ParameterCheckUtils.isNotNullOrEmpty(id, "id");
        return HtmlPageUtils.findSingleHtmlElementByXPath(page, "//*[@id='" + id + "']");
    }

    public static <T extends HtmlElement> T findSingleHtmlElementByXPath(HtmlPage page, String xpath) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(xpath, "xpath");
        List result = page.getByXPath(xpath);
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug("Found " + result.size() + " element(s) for XPath: " + xpath);
        }
        Assert.assertEquals((String)("No or too many elements found for XPath: " + xpath + " -"), (long)1L, (long)result.size());
        return (T)((HtmlElement)result.get(0));
    }

    public static <T extends HtmlElement> List<T> findHtmlElements(HtmlElement element, String xpath) {
        ParameterCheckUtils.isNotNull(element, "element");
        ParameterCheckUtils.isRelativePath(xpath, "xpath");
        List elements = element.getByXPath(xpath);
        Assert.assertTrue((String)("No elements found for XPath: " + xpath), (!elements.isEmpty() ? 1 : 0) != 0);
        return elements;
    }

    public static <T extends HtmlElement> T findHtmlElementsAndPickOne(HtmlElement element, String xpath) {
        return HtmlPageUtils.findHtmlElementsAndPickOne(element, xpath, false, false);
    }

    public static <T extends HtmlElement> T findHtmlElementsAndPickOne(HtmlElement element, String xpath, boolean excludeFirst) {
        return HtmlPageUtils.findHtmlElementsAndPickOne(element, xpath, excludeFirst, false);
    }

    public static <T extends HtmlElement> T findHtmlElementsAndPickOne(HtmlElement element, String xpath, boolean excludeFirst, boolean excludeLast) {
        List<T> elements = HtmlPageUtils.findHtmlElements(element, xpath);
        return (T)((HtmlElement)HtmlPageUtils.pickOneRandomly(elements, excludeFirst, excludeLast));
    }

    public static <T extends HtmlElement> T findSingleHtmlElementByXPath(HtmlElement element, String xpath) {
        ParameterCheckUtils.isNotNull(element, "element");
        ParameterCheckUtils.isRelativePath(xpath, "xpath");
        List result = element.getByXPath(xpath);
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug("Found " + result.size() + " element(s) for XPath: " + xpath);
        }
        Assert.assertEquals((String)("No or too many elements found for XPath: " + xpath + " -"), (long)1L, (long)result.size());
        return (T)((HtmlElement)result.get(0));
    }

    public static HtmlAnchor getAnchorWithText(HtmlPage page, String anchorText) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(anchorText, "anchorText");
        return (HtmlAnchor)HtmlPageUtils.findSingleHtmlElementByXPath(page, "//a[contains(., '" + anchorText + "')]");
    }

    public static HtmlPage getFramePage(HtmlPage page, String ... frameNames) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(frameNames, "frameNames");
        HtmlPage framePage = null;
        for (int i = 0; i < frameNames.length; ++i) {
            FrameWindow frameWindow = null;
            frameWindow = i == 0 ? page.getFrameByName(frameNames[i]) : framePage.getFrameByName(frameNames[i]);
            framePage = (HtmlPage)frameWindow.getEnclosedPage();
        }
        return framePage;
    }

    public static <T extends HtmlInput> T getInputEndingWith(HtmlForm form, String suffix) {
        NodeList elements = form.getElementsByTagName("input");
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            HtmlInput input = (HtmlInput)element;
            String name = input.getNameAttribute();
            if (name == null || !name.endsWith(suffix)) continue;
            return (T)input;
        }
        return null;
    }

    public static <T extends HtmlInput> T getInputStartingWith(HtmlForm form, String prefix) {
        NodeList elements = form.getElementsByTagName("input");
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            HtmlInput input = (HtmlInput)element;
            String name = input.getNameAttribute();
            if (name == null || !name.startsWith(prefix)) continue;
            return (T)input;
        }
        return null;
    }

    public static HtmlSelect getSelectEndingWith(HtmlForm form, String suffix) {
        NodeList elements = form.getElementsByTagName("select");
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            HtmlSelect select = (HtmlSelect)element;
            String name = select.getNameAttribute();
            if (name == null || !name.endsWith(suffix)) continue;
            return select;
        }
        return null;
    }

    public static HtmlSelect getSelectStartingWith(HtmlForm form, String prefix) {
        NodeList elements = form.getElementsByTagName("select");
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            HtmlElement element = (HtmlElement)iterator.next();
            HtmlSelect select = (HtmlSelect)element;
            String name = select.getNameAttribute();
            if (name == null || !name.startsWith(prefix)) continue;
            return select;
        }
        return null;
    }

    public static void select(HtmlForm form, String selectName, String optionValue) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(selectName, "selectName");
        ParameterCheckUtils.isNotNull(optionValue, "optionValue");
        List<HtmlSelect> selects = form.getSelectsByName(selectName);
        Assert.assertEquals((String)("No or too many selects found for name: " + selectName + " -"), (long)1L, (long)selects.size());
        selects.get(0).setSelectedAttribute(optionValue, true);
    }

    public static void selectRandomly(HtmlForm form, String selectName) {
        HtmlPageUtils.selectRandomly(form, selectName, false, false);
    }

    public static void selectRandomly(HtmlForm form, String selectName, boolean excludeFirst) {
        HtmlPageUtils.selectRandomly(form, selectName, excludeFirst, false);
    }

    public static void selectRandomly(HtmlForm form, String selectName, boolean excludeFirst, boolean excludeLast) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(selectName, "selectName");
        List<HtmlSelect> selects = form.getSelectsByName(selectName);
        Assert.assertEquals((String)("No or too many selects found for name: " + selectName), (long)1L, (long)selects.size());
        HtmlSelect select = selects.get(0);
        ArrayList<HtmlOption> origOptions = new ArrayList<HtmlOption>(select.getOptions());
        ArrayList<HtmlOption> options = new ArrayList<HtmlOption>(origOptions.size());
        for (int i = 0; i < origOptions.size(); ++i) {
            HtmlOption option = (HtmlOption)origOptions.get(i);
            if (option.isDisabled()) continue;
            options.add(option);
        }
        HtmlOption option = (HtmlOption)HtmlPageUtils.pickOneRandomly(options, excludeFirst, excludeLast);
        select.setSelectedAttribute(option, true);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Setting select value: %s.%s = %s", HtmlPageUtils.getIdOrName(form), HtmlPageUtils.getIdOrName(select), option.getValueAttribute()));
        }
    }

    public static void setCheckBoxValue(HtmlForm form, String checkBoxName, boolean isChecked) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(checkBoxName, "checkBoxName");
        Object input = form.getInputByName(checkBoxName);
        Assert.assertEquals((String)"Found input element is not a check box", HtmlCheckBoxInput.class, input.getClass());
        ((HtmlCheckBoxInput)input).setChecked(isChecked);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Setting check box value: %s.%s = %b", HtmlPageUtils.getIdOrName(form), checkBoxName, isChecked));
        }
    }

    public static void setInputValue(HtmlForm form, String inputName, String value) {
        ParameterCheckUtils.isNotNull(form, "form");
        ParameterCheckUtils.isNotNullOrEmpty(inputName, "inputName");
        Object input = form.getInputByName(inputName);
        ((HtmlInput)input).setValue(value);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("Setting input value: %s.%s = %s", HtmlPageUtils.getIdOrName(form), inputName, value));
        }
    }

    public static List<HtmlForm> getFormsByIDRegExp(HtmlPage page, Pattern pattern) {
        List<HtmlForm> forms = page.getForms();
        ArrayList<HtmlForm> matchingForms = new ArrayList<HtmlForm>();
        for (HtmlForm form : forms) {
            if (!pattern.matcher(form.getId()).matches()) continue;
            matchingForms.add(form);
        }
        return matchingForms;
    }

    public static List<HtmlForm> getFormsByNameRegExp(HtmlPage page, Pattern pattern) {
        List<HtmlForm> forms = page.getForms();
        ArrayList<HtmlForm> matchingForms = new ArrayList<HtmlForm>();
        for (HtmlForm form : forms) {
            if (!pattern.matcher(form.getNameAttribute()).matches()) continue;
            matchingForms.add(form);
        }
        return matchingForms;
    }

    public static boolean isElementPresent(HtmlPage page, String xpath) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(xpath, "xpath");
        return !page.getByXPath(xpath).isEmpty();
    }

    public static boolean isElementPresent(HtmlElement element, String xpath) {
        ParameterCheckUtils.isNotNull(element, "element");
        ParameterCheckUtils.isNotNullOrEmpty(xpath, "xpath");
        return !element.getByXPath(xpath).isEmpty();
    }

    public static int countElementsByXPath(HtmlPage page, String xpath) {
        ParameterCheckUtils.isNotNull(page, "page");
        ParameterCheckUtils.isNotNullOrEmpty(xpath, "xpath");
        return page.getByXPath(xpath).size();
    }

    public static <T extends HtmlElement> List<T> waitForHtmlElements(HtmlPage page, String xpath, long timeout) throws InterruptedException {
        timeout = Math.max(0L, timeout);
        long startTime = TimerUtils.get().getStartTime();
        while (TimerUtils.get().getElapsedTime(startTime) < timeout) {
            try {
                return HtmlPageUtils.findHtmlElements(page, xpath);
            }
            catch (AssertionError e) {
                Thread.sleep(500L);
            }
        }
        Assert.fail((String)String.format("Timed-out after waiting %,d ms - Still no elements found for XPath: %s", timeout, xpath));
        return null;
    }

    private static String getIdOrName(HtmlElement element) {
        ParameterCheckUtils.isNotNull(element, "element");
        String result = element.getId();
        if (result == null || result.length() == 0) {
            result = element.getAttribute("name");
        }
        if (result == null || result.length() == 0) {
            result = "<unnamed>";
        }
        return result;
    }
}

