/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.lang.StringUtils;
import java.net.URL;
import java.util.Stack;

public class RequestStack
implements Cloneable {
    private static ThreadLocal<RequestStack> current = new ThreadLocal();
    private int counter;
    private Stack<Integer> stack = new Stack();
    private String timerName;

    public static RequestStack getCurrent() {
        RequestStack requestStack = current.get();
        if (requestStack == null) {
            requestStack = new RequestStack();
            current.set(requestStack);
        }
        return requestStack;
    }

    public static void setCurrent(RequestStack requestStack) {
        current.set(requestStack);
    }

    public RequestStack clone() {
        try {
            RequestStack clone = (RequestStack)super.clone();
            clone.stack = (Stack)this.stack.clone();
            clone.counter = this.counter++;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone?!?", ex);
        }
    }

    public String getHierarchicalRequestName(URL url) {
        StringBuilder buf = new StringBuilder(this.getHierarchicalTimerName());
        String lastPathElement = this.getLastPathElement(url);
        if (!"".equals(lastPathElement)) {
            buf.append("-").append(lastPathElement);
        }
        return buf.toString();
    }

    public String getHierarchicalTimerName() {
        StringBuilder buf = new StringBuilder(this.timerName);
        int maxIdx = this.stack.size();
        for (int i = 0; i < maxIdx; ++i) {
            int subRequestId = (Integer)this.stack.get(i);
            if (i >= maxIdx - 1 && subRequestId <= 0) continue;
            buf.append(".").append(subRequestId);
        }
        return buf.toString();
    }

    public String getHierarchicalTimerName(URL url) {
        StringBuilder buf = new StringBuilder(this.timerName);
        int maxIdx = this.stack.size();
        for (int i = 0; i < maxIdx; ++i) {
            int subRequestId = (Integer)this.stack.get(i);
            if (i >= maxIdx - 1 && subRequestId <= 0) continue;
            buf.append(".").append(StringUtils.crc32(url.toString()));
        }
        return buf.toString();
    }

    private String getLastPathElement(URL url) {
        String path = url.getPath();
        path = org.apache.commons.lang3.StringUtils.substringBefore((String)path, (String)";");
        return org.apache.commons.lang3.StringUtils.substringAfterLast((String)path, (String)"/");
    }

    public void popRequest() {
        this.counter = this.stack.pop();
    }

    public void pushRequest() {
        this.stack.push(++this.counter);
    }

    public void popPage() {
        this.counter = this.stack.pop();
    }

    public void pushPage() {
        this.stack.push(++this.counter);
        this.counter = -1;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    public int size() {
        return this.stack.size();
    }

    public void reset() {
        this.counter = 0;
    }
}

