/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder(value={"size", "compression", "mimeType", "text", "comment"})
public class HarContent {
    private final long size;
    private final Long compression;
    private final String mimeType;
    private final String text;
    private final String comment;

    @JsonCreator
    public HarContent(@JsonProperty(value="size") Long size, @JsonProperty(value="compression") Long compression, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="text") String text, @JsonProperty(value="comment") String comment) {
        this.size = size;
        this.compression = compression;
        this.mimeType = mimeType;
        this.text = text;
        this.comment = comment;
    }

    public String getText() {
        return this.text;
    }

    public String getComment() {
        return this.comment;
    }

    public Long getCompression() {
        return this.compression;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return "HarContent [text = " + this.text + ", comment = " + this.comment + ", compression = " + this.compression + ", mimeType = " + this.mimeType + ", size = " + this.size + "]";
    }

    public static class Builder {
        private long size = -1L;
        private Long compression;
        private String mimeType;
        private String text;
        private String comment;

        public Builder withSize(long size) {
            this.size = size;
            return this;
        }

        public Builder withCompression(Long compression) {
            this.compression = compression;
            return this;
        }

        public Builder withMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarContent build() {
            return new HarContent(this.size, this.compression, this.mimeType, this.text, this.comment);
        }
    }
}

