/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import com.xceptance.xlt.engine.scripting.docgen.Marked;

@XStreamAlias(value="step")
public class Step {
    final String name;
    private String description;
    @XStreamAsAttribute
    final boolean disabled;
    final boolean moduleCall;
    final Condition condition;
    private transient String descriptionMarkup;

    Step(String name, String description, boolean disabled, boolean isModuleCall, boolean conditionDisabled, String conditionExpression) {
        this.name = name;
        this.description = description;
        this.disabled = disabled;
        this.moduleCall = isModuleCall;
        this.condition = conditionExpression == null ? null : new Condition(conditionDisabled, conditionExpression);
    }

    Step(String name, String description, boolean disabled) {
        this(name, description, disabled, false, false, null);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionMarkup() {
        if (this.descriptionMarkup == null) {
            this.descriptionMarkup = Marked.getInstance().markdownToHTML(this.getDescription());
        }
        return this.descriptionMarkup;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isModuleCall() {
        return this.moduleCall;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionMarkup = null;
    }

    public Condition getCondition() {
        return this.condition;
    }

    @XStreamConverter(value=ToAttributedValueConverter.class, strings={"expression"})
    public static class Condition {
        @XStreamAsAttribute
        final boolean disabled;
        final String expression;

        public Condition(boolean isDisabled, String cExpression) {
            this.disabled = isDisabled;
            this.expression = cExpression;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

