/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import org.apache.commons.lang3.StringUtils;

public abstract class Condition {
    private final String description;
    private boolean _satisfied;
    private String _reason;

    public Condition(String aDescription) {
        this.description = aDescription;
    }

    public Condition(String messageFormat, Object ... args) {
        this(String.format(messageFormat, args));
    }

    public String toString() {
        return "Condition [".concat(this.description).concat("]");
    }

    public String getDescription() {
        return this.description;
    }

    public String getReason() {
        return StringUtils.defaultString((String)this._reason, (String)(this + (this._satisfied ? "" : "not") + " satisfied"));
    }

    public final boolean isTrue() {
        this._satisfied = false;
        this._reason = null;
        try {
            this._satisfied = this.evaluate();
        }
        catch (Throwable t) {
            this._reason = t.getMessage();
            throw t;
        }
        return this._satisfied;
    }

    protected abstract boolean evaluate();

    protected void setReason(String aReason) {
        this._reason = aReason;
    }
}

