/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.InputStream;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XltChartTheme
extends StandardChartTheme {
    private static final Color _DEFAULT_OUTLINE_PAINT;
    private static final Stroke _DEFAULT_OUTLINE_STROKE;
    private static final boolean AXIS_LINE_VISIBLE = false;
    private static final Paint AXIS_TICK_MARK_PAINT;
    private static final Paint CHART_BACKGROUND_PAINT;
    private static final RectangleInsets CHART_PADDING;
    private static final Font FONT_EXTRA_LARGE;
    private static final Font FONT_LARGE;
    private static final Font FONT_REGULAR;
    private static final Font FONT_SMALL;
    private static final LineBorder LEGEND_BORDER;
    private static final RectangleInsets LEGEND_PADDING;
    private static final Paint PLOT_BACKGROUND_PAINT;
    private static final Paint PLOT_GRID_LINE_PAINT;
    private static final Paint TEXT_PAINT;
    private static final XYBarPainter YX_BAR_PAINTER;
    private static final Logger LOG;
    private static final int TEXTTITLE_MAXLINES = 1;
    private static final RectangleInsets TEXTTITLE_PADDING;

    private static Font loadFont(String fontFileName) throws Exception {
        try (InputStream fontStream = XltChartTheme.class.getResourceAsStream(fontFileName);){
            Font font = Font.createFont(0, fontStream);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            Font font2 = font;
            return font2;
        }
    }

    public XltChartTheme() {
        super("XLT");
        this.setExtraLargeFont(FONT_EXTRA_LARGE);
        this.setLargeFont(FONT_LARGE);
        this.setRegularFont(FONT_REGULAR);
        this.setSmallFont(FONT_SMALL);
        this.setTitlePaint(TEXT_PAINT);
        this.setChartBackgroundPaint(CHART_BACKGROUND_PAINT);
        this.setPlotBackgroundPaint(PLOT_BACKGROUND_PAINT);
        this.setPlotOutlinePaint(_DEFAULT_OUTLINE_PAINT);
        this.setAxisOffset(RectangleInsets.ZERO_INSETS);
        this.setDomainGridlinePaint(PLOT_GRID_LINE_PAINT);
        this.setRangeGridlinePaint(PLOT_GRID_LINE_PAINT);
        this.setXYBarPainter(YX_BAR_PAINTER);
        this.setAxisLabelPaint(TEXT_PAINT);
        this.setTickLabelPaint(TEXT_PAINT);
        this.setLegendItemPaint(TEXT_PAINT);
        this.setItemLabelPaint(TEXT_PAINT);
    }

    public void apply(JFreeChart chart) {
        super.apply(chart);
        TextTitle title = chart.getTitle();
        if (title != null) {
            title.setMaximumLinesToDisplay(1);
            title.setPadding(TEXTTITLE_PADDING);
        }
        chart.setPadding(CHART_PADDING);
    }

    public void applyToPlot(Plot plot) {
        super.applyToPlot(plot);
        plot.setOutlineStroke(_DEFAULT_OUTLINE_STROKE);
    }

    protected void applyToAbstractRenderer(AbstractRenderer renderer) {
    }

    protected void applyToTitle(Title title) {
        super.applyToTitle(title);
        if (title instanceof LegendTitle) {
            LegendTitle legendTitle = (LegendTitle)title;
            legendTitle.setFrame((BlockFrame)LEGEND_BORDER);
            legendTitle.setPadding(LEGEND_PADDING);
        }
    }

    protected void applyToValueAxis(ValueAxis axis) {
        super.applyToValueAxis(axis);
        axis.setTickLabelFont(FONT_SMALL);
        axis.setTickMarkPaint(AXIS_TICK_MARK_PAINT);
        axis.setAxisLineVisible(false);
    }

    static {
        Font smallFont;
        Font regularFont;
        Font largeFont;
        Font extraLargeFont;
        _DEFAULT_OUTLINE_PAINT = new Color(0xBFBFBF);
        _DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
        AXIS_TICK_MARK_PAINT = _DEFAULT_OUTLINE_PAINT;
        CHART_BACKGROUND_PAINT = new Color(0xFAFAFA);
        CHART_PADDING = new RectangleInsets(8.0, 0.0, 8.0, 2.0);
        LEGEND_BORDER = new LineBorder((Paint)_DEFAULT_OUTLINE_PAINT, _DEFAULT_OUTLINE_STROKE, new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        LEGEND_PADDING = new RectangleInsets(1.0, 4.0, 1.0, 4.0);
        PLOT_BACKGROUND_PAINT = Color.WHITE;
        PLOT_GRID_LINE_PAINT = Color.LIGHT_GRAY;
        TEXT_PAINT = new Color(0x333333);
        YX_BAR_PAINTER = new StandardXYBarPainter();
        LOG = LoggerFactory.getLogger(XltChartTheme.class);
        TEXTTITLE_PADDING = new RectangleInsets(1.0, 100.0, 1.0, 100.0);
        try {
            Font boldFont = XltChartTheme.loadFont("Roboto-Medium.ttf");
            Font plainFont = XltChartTheme.loadFont("Roboto-Regular.ttf");
            extraLargeFont = boldFont.deriveFont(13.0f);
            largeFont = plainFont.deriveFont(12.0f);
            regularFont = plainFont.deriveFont(12.0f);
            smallFont = plainFont.deriveFont(10.0f);
        }
        catch (Exception e) {
            LOG.error("Failed to load chart text font", (Throwable)e);
            extraLargeFont = new Font("SansSerif", 1, 12);
            largeFont = new Font("SansSerif", 0, 12);
            regularFont = new Font("SansSerif", 0, 12);
            smallFont = new Font("SansSerif", 0, 10);
        }
        FONT_EXTRA_LARGE = extraLargeFont;
        FONT_LARGE = largeFont;
        FONT_REGULAR = regularFont;
        FONT_SMALL = smallFont;
    }
}

