/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.RefreshHandler;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;

public class WaitingRefreshHandler
implements RefreshHandler {
    private static final Log LOG = LogFactory.getLog(WaitingRefreshHandler.class);
    private final int maxwait_;

    public WaitingRefreshHandler(int maxwait) {
        this.maxwait_ = maxwait;
    }

    public WaitingRefreshHandler() {
        this.maxwait_ = 0;
    }

    @Override
    public void handleRefresh(Page page, URL url, int requestedWait) throws IOException {
        block4: {
            int seconds = requestedWait;
            if (seconds > this.maxwait_ && this.maxwait_ > 0) {
                seconds = this.maxwait_;
            }
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Waiting thread was interrupted. Ignoring interruption to continue navigation.");
            }
        }
        WebWindow window = page.getEnclosingWindow();
        if (window == null) {
            return;
        }
        WebClient client = window.getWebClient();
        client.getPage(window, new WebRequest(url));
    }
}

