/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.html.DomChangeEvent;
import org.htmlunit.html.DomChangeListener;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomNodeList;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlAttributeChangeListener;
import org.htmlunit.html.HtmlElement;
import org.w3c.dom.Node;

public abstract class AbstractDomNodeList<E extends DomNode>
extends AbstractList<E>
implements DomNodeList<E>,
Serializable {
    private DomNode node_;
    private List<E> cachedElements_;

    public AbstractDomNodeList(DomNode node) {
        if (node != null) {
            this.node_ = node;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    protected DomNode getDomNode() {
        return this.node_;
    }

    protected abstract List<E> provideElements();

    private List<E> getNodes() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.node_ == null ? new ArrayList() : this.provideElements();
        }
        return this.cachedElements_;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public int getLength() {
        return this.getNodes().size();
    }

    @Override
    public Node item(int index) {
        return (Node)this.getNodes().get(index);
    }

    @Override
    public E get(int index) {
        return (E)((DomNode)this.getNodes().get(index));
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private final transient WeakReference<AbstractDomNodeList<?>> nodeList_;

        DomHtmlAttributeChangeListenerImpl(AbstractDomNodeList<?> nodeList) {
            this.nodeList_ = new WeakReference(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.clearCache();
        }

        private void clearCache() {
            AbstractDomNodeList nodes;
            if (this.nodeList_ != null && (nodes = (AbstractDomNodeList)this.nodeList_.get()) != null) {
                nodes.cachedElements_ = null;
            }
        }
    }
}

