/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;

public class HtmlMonthInput
extends HtmlInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-MM");

    HtmlMonthInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        try {
            if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && StringUtils.isNotEmpty((CharSequence)newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValue(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                YearMonth dateValue = YearMonth.parse(this.getRawValue(), FORMATTER_);
                YearMonth minDate = YearMonth.parse(this.getMin(), FORMATTER_);
                return minDate.equals(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                YearMonth dateValue = YearMonth.parse(this.getRawValue(), FORMATTER_);
                YearMonth maxDate = YearMonth.parse(this.getMax(), FORMATTER_);
                return maxDate.equals(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

