/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;

public class HtmlUnknownElement
extends HtmlElement {
    private boolean createdByJavascript_;

    HtmlUnknownElement(SgmlPage page, String tagName, Map<String, DomAttr> attributes) {
        super(tagName, page, attributes);
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        switch (this.getTagName()) {
            case "ruby": {
                if (this.hasFeature(BrowserVersionFeatures.CSS_RUBY_DISPLAY_INLINE)) {
                    return HtmlElement.DisplayStyle.INLINE;
                }
                return HtmlElement.DisplayStyle.RUBY;
            }
            case "rp": {
                if (this.hasFeature(BrowserVersionFeatures.CSS_RP_DISPLAY_NONE)) {
                    return HtmlElement.DisplayStyle.NONE;
                }
                if (!this.wasCreatedByJavascript() || this.getParentNode() != null) break;
                return HtmlElement.DisplayStyle.BLOCK;
            }
            case "rt": {
                if (!this.hasFeature(BrowserVersionFeatures.CSS_RT_DISPLAY_RUBY_TEXT_ALWAYS) && this.wasCreatedByJavascript() && this.getParentNode() == null) {
                    return HtmlElement.DisplayStyle.BLOCK;
                }
                return HtmlElement.DisplayStyle.RUBY_TEXT;
            }
            case "multicol": {
                if (!this.hasFeature(BrowserVersionFeatures.MULTICOL_BLOCK)) break;
                return HtmlElement.DisplayStyle.BLOCK;
            }
            case "dialog": {
                if (!this.hasFeature(BrowserVersionFeatures.CSS_DIALOG_NONE)) break;
                return HtmlElement.DisplayStyle.NONE;
            }
            case "slot": {
                if (!this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.SLOT_CONTENTS)) break;
                return HtmlElement.DisplayStyle.CONTENTS;
            }
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }
}

