/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;

public class HtmlWeekInput
extends HtmlInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-'W'ww");

    HtmlWeekInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        if (!this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) || StringUtils.isEmpty((CharSequence)newValue)) {
            super.setValue(newValue);
            return;
        }
        try {
            FORMATTER_.parse(newValue);
            super.setValue(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getRawValue() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                LocalDate minDate = LocalDate.parse(this.getMin() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                return minDate.isEqual(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getRawValue() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                LocalDate maxDate = LocalDate.parse(this.getMax() + "-1", DateTimeFormatter.ISO_WEEK_DATE);
                return maxDate.isEqual(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

