/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.htmlunit.SgmlPage;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.impl.SelectableTextInput;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class SimpleRange
implements Range,
Serializable {
    private Node startContainer_;
    private Node endContainer_;
    private int startOffset_;
    private int endOffset_;

    public SimpleRange() {
    }

    public SimpleRange(Node node) {
        this.startContainer_ = node;
        this.endContainer_ = node;
        this.startOffset_ = 0;
        this.endOffset_ = SimpleRange.getMaxOffset(node);
    }

    public SimpleRange(Node node, int offset) {
        this.startContainer_ = node;
        this.endContainer_ = node;
        this.startOffset_ = offset;
        this.endOffset_ = offset;
    }

    public SimpleRange(Node startNode, int startOffset, Node endNode, int endOffset) {
        this.startContainer_ = startNode;
        this.endContainer_ = endNode;
        this.startOffset_ = startOffset;
        this.endOffset_ = endOffset;
        if (startNode == endNode && startOffset > endOffset) {
            this.endOffset_ = startOffset;
        }
    }

    @Override
    public DomDocumentFragment cloneContents() throws DOMException {
        DomNode n;
        DomNode ancestor = (DomNode)this.getCommonAncestorContainer();
        if (ancestor == null) {
            return new DomDocumentFragment(null);
        }
        DomNode ancestorClone = ancestor.cloneNode(true);
        DomNode startClone = null;
        DomNode endClone = null;
        DomNode start = (DomNode)this.startContainer_;
        DomNode end = (DomNode)this.endContainer_;
        if (start == ancestor) {
            startClone = ancestorClone;
        }
        if (end == ancestor) {
            endClone = ancestorClone;
        }
        Iterable<DomNode> descendants = ancestor.getDescendants();
        if (startClone == null || endClone == null) {
            Iterator<DomNode> i = descendants.iterator();
            Iterator<DomNode> ci = ancestorClone.getDescendants().iterator();
            while (i.hasNext()) {
                DomNode e = i.next();
                DomNode ce = ci.next();
                if (start == e) {
                    startClone = ce;
                    continue;
                }
                if (end != e) continue;
                endClone = ce;
                break;
            }
        }
        if (endClone == null) {
            throw Context.reportRuntimeError((String)"Unable to find end node clone.");
        }
        SimpleRange.deleteAfter(endClone, this.endOffset_);
        for (n = endClone; n != null; n = n.getParentNode()) {
            while (n.getNextSibling() != null) {
                n.getNextSibling().remove();
            }
        }
        if (startClone == null) {
            throw Context.reportRuntimeError((String)"Unable to find start node clone.");
        }
        SimpleRange.deleteBefore(startClone, this.startOffset_);
        for (n = startClone; n != null; n = n.getParentNode()) {
            while (n.getPreviousSibling() != null) {
                n.getPreviousSibling().remove();
            }
        }
        SgmlPage page = ancestor.getPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        if (start == end) {
            fragment.appendChild(ancestorClone);
        } else {
            Iterator iterator = ancestorClone.getChildNodes().iterator();
            while (iterator.hasNext()) {
                DomNode n2 = (DomNode)iterator.next();
                fragment.appendChild(n2);
            }
        }
        return fragment;
    }

    @Override
    public Range cloneRange() throws DOMException {
        return new SimpleRange(this.startContainer_, this.startOffset_, this.endContainer_, this.endOffset_);
    }

    @Override
    public void collapse(boolean toStart) throws DOMException {
        if (toStart) {
            this.endContainer_ = this.startContainer_;
            this.endOffset_ = this.startOffset_;
        } else {
            this.startContainer_ = this.endContainer_;
            this.startOffset_ = this.endOffset_;
        }
    }

    @Override
    public short compareBoundaryPoints(short how, Range sourceRange) throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void deleteContents() throws DOMException {
        DomNode ancestor = (DomNode)this.getCommonAncestorContainer();
        if (ancestor != null) {
            this.deleteContents(ancestor);
        }
    }

    private void deleteContents(DomNode ancestor) {
        DomNode n;
        DomNode end;
        String text;
        DomNode start;
        if (SimpleRange.isOffsetChars(this.startContainer_)) {
            start = (DomNode)this.startContainer_;
            text = SimpleRange.getText(start);
            if (this.startOffset_ > -1 && this.startOffset_ < text.length()) {
                text = text.substring(0, this.startOffset_);
            }
            SimpleRange.setText(start, text);
        } else {
            start = this.startContainer_.getChildNodes().getLength() > this.startOffset_ ? (DomNode)this.startContainer_.getChildNodes().item(this.startOffset_) : (DomNode)this.startContainer_.getNextSibling();
        }
        if (SimpleRange.isOffsetChars(this.endContainer_)) {
            end = (DomNode)this.endContainer_;
            text = SimpleRange.getText(end);
            if (this.endOffset_ > -1 && this.endOffset_ < text.length()) {
                text = text.substring(this.endOffset_);
            }
            SimpleRange.setText(end, text);
        } else {
            end = this.endContainer_.getChildNodes().getLength() > this.endOffset_ ? (DomNode)this.endContainer_.getChildNodes().item(this.endOffset_) : (DomNode)this.endContainer_.getNextSibling();
        }
        boolean foundStart = false;
        boolean started = false;
        Iterator<DomNode> i = ancestor.getDescendants().iterator();
        while (i.hasNext() && (n = i.next()) != end) {
            if (n == start) {
                foundStart = true;
            }
            if (foundStart && (n != start || !SimpleRange.isOffsetChars(this.startContainer_))) {
                started = true;
            }
            if (!started || n.isAncestorOf(end)) continue;
            i.remove();
        }
    }

    @Override
    public void detach() throws DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public DomDocumentFragment extractContents() throws DOMException {
        DomDocumentFragment fragment = this.cloneContents();
        this.deleteContents();
        return fragment;
    }

    @Override
    public boolean getCollapsed() throws DOMException {
        return this.startContainer_ == this.endContainer_ && this.startOffset_ == this.endOffset_;
    }

    @Override
    public Node getCommonAncestorContainer() throws DOMException {
        if (this.startContainer_ != null && this.endContainer_ != null) {
            for (Node p1 = this.startContainer_; p1 != null; p1 = p1.getParentNode()) {
                for (Node p2 = this.endContainer_; p2 != null; p2 = p2.getParentNode()) {
                    if (p1 != p2) continue;
                    return p1;
                }
            }
        }
        return null;
    }

    @Override
    public Node getEndContainer() throws DOMException {
        return this.endContainer_;
    }

    @Override
    public int getEndOffset() throws DOMException {
        return this.endOffset_;
    }

    @Override
    public Node getStartContainer() throws DOMException {
        return this.startContainer_;
    }

    @Override
    public int getStartOffset() throws DOMException {
        return this.startOffset_;
    }

    @Override
    public void insertNode(Node newNode) throws DOMException, RangeException {
        if (SimpleRange.isOffsetChars(this.startContainer_)) {
            Node split = this.startContainer_.cloneNode(false);
            String text = SimpleRange.getText(this.startContainer_);
            if (this.startOffset_ > -1 && this.startOffset_ < text.length()) {
                text = text.substring(0, this.startOffset_);
            }
            SimpleRange.setText(this.startContainer_, text);
            text = SimpleRange.getText(split);
            if (this.startOffset_ > -1 && this.startOffset_ < text.length()) {
                text = text.substring(this.startOffset_);
            }
            SimpleRange.setText(split, text);
            SimpleRange.insertNodeOrDocFragment(this.startContainer_.getParentNode(), split, this.startContainer_.getNextSibling());
            SimpleRange.insertNodeOrDocFragment(this.startContainer_.getParentNode(), newNode, split);
        } else {
            SimpleRange.insertNodeOrDocFragment(this.startContainer_, newNode, this.startContainer_.getChildNodes().item(this.startOffset_));
        }
        this.setStart(newNode, 0);
    }

    private static void insertNodeOrDocFragment(Node parent, Node newNode, Node refNode) {
        if (newNode instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newNode;
            NodeList childNodes = fragment.getChildNodes();
            while (childNodes.getLength() > 0) {
                Node item = childNodes.item(0);
                parent.insertBefore(item, refNode);
            }
        } else {
            parent.insertBefore(newNode, refNode);
        }
    }

    @Override
    public void selectNode(Node node) throws RangeException, DOMException {
        this.startContainer_ = node;
        this.startOffset_ = 0;
        this.endContainer_ = node;
        this.endOffset_ = SimpleRange.getMaxOffset(node);
    }

    @Override
    public void selectNodeContents(Node node) throws RangeException, DOMException {
        this.startContainer_ = node.getFirstChild();
        this.startOffset_ = 0;
        this.endContainer_ = node.getLastChild();
        this.endOffset_ = SimpleRange.getMaxOffset(node.getLastChild());
    }

    @Override
    public void setEnd(Node refNode, int offset) throws RangeException, DOMException {
        this.endContainer_ = refNode;
        this.endOffset_ = offset;
    }

    @Override
    public void setEndAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void setEndBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void setStart(Node refNode, int offset) throws RangeException, DOMException {
        this.startContainer_ = refNode;
        this.startOffset_ = offset;
    }

    @Override
    public void setStartAfter(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void setStartBefore(Node refNode) throws RangeException, DOMException {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void surroundContents(Node newParent) throws DOMException, RangeException {
        newParent.appendChild(this.extractContents());
        this.insertNode(newParent);
        this.setStart(newParent, 0);
        this.setEnd(newParent, SimpleRange.getMaxOffset(newParent));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleRange)) {
            return false;
        }
        SimpleRange other = (SimpleRange)obj;
        return new EqualsBuilder().append((Object)this.startContainer_, (Object)other.startContainer_).append((Object)this.endContainer_, (Object)other.endContainer_).append(this.startOffset_, other.startOffset_).append(this.endOffset_, other.endOffset_).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.startContainer_).append((Object)this.endContainer_).append(this.startOffset_).append(this.endOffset_).toHashCode();
    }

    @Override
    public String toString() {
        DomDocumentFragment fragment = this.cloneContents();
        if (fragment.getPage() != null) {
            return fragment.asNormalizedText();
        }
        return "";
    }

    private static boolean isOffsetChars(Node node) {
        return node instanceof DomText || node instanceof SelectableTextInput;
    }

    private static String getText(Node node) {
        if (node instanceof SelectableTextInput) {
            return ((SelectableTextInput)node).getText();
        }
        return node.getTextContent();
    }

    private static void setText(Node node, String text) {
        if (node instanceof SelectableTextInput) {
            ((SelectableTextInput)node).setText(text);
        } else {
            node.setTextContent(text);
        }
    }

    private static void deleteBefore(DomNode node, int offset) {
        if (SimpleRange.isOffsetChars(node)) {
            String text = SimpleRange.getText(node);
            text = offset > -1 && offset < text.length() ? text.substring(offset) : "";
            SimpleRange.setText(node, text);
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < offset && i < children.getLength(); --offset, ++i) {
                DomNode child = (DomNode)children.get(i);
                child.remove();
                --i;
            }
        }
    }

    private static void deleteAfter(DomNode node, int offset) {
        if (SimpleRange.isOffsetChars(node)) {
            String text = SimpleRange.getText(node);
            if (offset > -1 && offset < text.length()) {
                text = text.substring(0, offset);
                SimpleRange.setText(node, text);
            }
        } else {
            NodeList children = node.getChildNodes();
            for (int i = offset; i < children.getLength(); ++i) {
                DomNode child = (DomNode)children.get(i);
                child.remove();
                --i;
            }
        }
    }

    private static int getMaxOffset(Node node) {
        return SimpleRange.isOffsetChars(node) ? SimpleRange.getText(node).length() : node.getChildNodes().getLength();
    }

    public List<DomNode> containedNodes() {
        DomNode end;
        String text;
        DomNode start;
        ArrayList<DomNode> nodes = new ArrayList<DomNode>();
        DomNode ancestor = (DomNode)this.getCommonAncestorContainer();
        if (ancestor == null) {
            return nodes;
        }
        if (SimpleRange.isOffsetChars(this.startContainer_)) {
            start = (DomNode)this.startContainer_;
            text = SimpleRange.getText(start);
            if (this.startOffset_ > -1 && this.startOffset_ < text.length()) {
                text = text.substring(0, this.startOffset_);
            }
            SimpleRange.setText(start, text);
        } else {
            start = this.startContainer_.getChildNodes().getLength() > this.startOffset_ ? (DomNode)this.startContainer_.getChildNodes().item(this.startOffset_) : (DomNode)this.startContainer_.getNextSibling();
        }
        if (SimpleRange.isOffsetChars(this.endContainer_)) {
            end = (DomNode)this.endContainer_;
            text = SimpleRange.getText(end);
            if (this.endOffset_ > -1 && this.endOffset_ < text.length()) {
                text = text.substring(this.endOffset_);
            }
            SimpleRange.setText(end, text);
        } else {
            end = this.endContainer_.getChildNodes().getLength() > this.endOffset_ ? (DomNode)this.endContainer_.getChildNodes().item(this.endOffset_) : (DomNode)this.endContainer_.getNextSibling();
        }
        boolean foundStart = false;
        boolean started = false;
        for (DomNode n : ancestor.getDescendants()) {
            if (n == end) break;
            if (n == start) {
                foundStart = true;
            }
            if (foundStart && (n != start || !SimpleRange.isOffsetChars(this.startContainer_))) {
                started = true;
            }
            if (!started || n.isAncestorOf(end)) continue;
            nodes.add(n);
        }
        return nodes;
    }
}

