/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.parser.neko;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ObjectInstantiationException;
import org.htmlunit.WebClient;
import org.htmlunit.WebResponse;
import org.htmlunit.cyberneko.HTMLConfiguration;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.HTMLEventInfo;
import org.htmlunit.cyberneko.HTMLTagBalancingListener;
import org.htmlunit.cyberneko.xerces.parsers.AbstractSAXParser;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XNIException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLErrorHandler;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLInputSource;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLParserConfiguration;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomDocumentType;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlHtml;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlMeta;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSvg;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTemplate;
import org.htmlunit.html.ScriptElement;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.XHtmlPage;
import org.htmlunit.html.parser.HTMLParser;
import org.htmlunit.html.parser.HTMLParserDOMBuilder;
import org.htmlunit.html.parser.HTMLParserListener;
import org.htmlunit.html.parser.neko.HtmlUnitNekoHTMLErrorHandler;
import org.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import org.htmlunit.javascript.host.html.HTMLBodyElement;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

final class HtmlUnitNekoDOMBuilder
extends AbstractSAXParser
implements ContentHandler,
LexicalHandler,
HTMLTagBalancingListener,
HTMLParserDOMBuilder {
    private static final Map<Triple<Boolean, Boolean, Boolean>, HTMLElements> ELEMENTS = new HashMap<Triple<Boolean, Boolean, Boolean>, HTMLElements>();
    private final HTMLParser htmlParser_;
    private final HtmlPage page_;
    private Locator locator_;
    private final Deque<DomNode> stack_ = new ArrayDeque<DomNode>();
    private boolean snippetStartNodeOverwritten_;
    private final int initialSize_;
    private DomNode currentNode_;
    private final boolean createdByJavascript_;
    private final StringBuilder characters_ = new StringBuilder();
    private HeadParsed headParsed_ = HeadParsed.NO;
    private HtmlElement body_;
    private boolean lastTagWasSynthesized_;
    private HtmlForm consumingForm_;
    private boolean formEndingIsAdjusting_;
    private boolean insideSvg_;
    private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushInputString(String html) {
        this.page_.registerParsingStart();
        this.page_.registerInlineSnippetParsingStart();
        try {
            WebResponse webResponse = this.page_.getWebResponse();
            Charset charset = webResponse.getContentCharset();
            String url = webResponse.getWebRequest().getUrl().toString();
            XMLInputSource in = new XMLInputSource(null, url, null, (Reader)new StringReader(html), charset.name());
            ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
        }
        finally {
            this.page_.registerParsingEnd();
            this.page_.registerInlineSnippetParsingEnd();
        }
    }

    HtmlUnitNekoDOMBuilder(HTMLParser htmlParser, DomNode node, URL url, String htmlContent, boolean createdByJavascript) {
        super(HtmlUnitNekoDOMBuilder.createConfiguration(node.getPage().getWebClient().getBrowserVersion()));
        boolean reportErrors;
        this.htmlParser_ = htmlParser;
        this.page_ = (HtmlPage)node.getPage();
        this.currentNode_ = node;
        for (Node ancestor : this.currentNode_.getAncestors()) {
            this.stack_.push((DomNode)ancestor);
        }
        this.createdByJavascript_ = createdByJavascript;
        WebClient webClient = this.page_.getWebClient();
        HTMLParserListener listener = webClient.getHTMLParserListener();
        boolean bl = reportErrors = listener != null;
        if (reportErrors) {
            this.fConfiguration.setErrorHandler((XMLErrorHandler)new HtmlUnitNekoHTMLErrorHandler(listener, url, htmlContent));
        }
        try {
            this.setFeature(FEATURE_AUGMENTATIONS, true);
            if (!webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_ATTRIBUTE_LOWER_CASE)) {
                this.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
            }
            this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
            this.setFeature(FEATURE_PARSE_NOSCRIPT, !webClient.isJavaScriptEnabled());
            this.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", false);
            this.setContentHandler(this);
            this.setLexicalHandler(this);
        }
        catch (SAXException e) {
            throw new ObjectInstantiationException("unable to create HTML parser", e);
        }
        this.initialSize_ = this.stack_.size();
    }

    private static XMLParserConfiguration createConfiguration(BrowserVersion browserVersion) {
        HTMLElements elements = ELEMENTS.get(Triple.of((Object)browserVersion.hasFeature(BrowserVersionFeatures.HTML_COMMAND_TAG), (Object)browserVersion.hasFeature(BrowserVersionFeatures.HTML_ISINDEX_TAG), (Object)browserVersion.hasFeature(BrowserVersionFeatures.HTML_MAIN_TAG)));
        return new HTMLConfiguration(elements);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = HtmlUnitNekoDOMBuilder.isSynthesized(augs);
        super.startElement(element, attributes, augs);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ElementFactory factory;
        if (this.snippetStartNodeOverwritten_) {
            this.snippetStartNodeOverwritten_ = false;
            return;
        }
        this.handleCharacters();
        String tagLower = StringUtils.toRootLowerCaseWithCache(localName);
        if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
            this.stack_.push(this.currentNode_);
            return;
        }
        if ("head".equals(tagLower)) {
            if (this.headParsed_ == HeadParsed.YES || this.page_.isParsingHtmlSnippet()) {
                this.stack_.push(this.currentNode_);
                return;
            }
            HeadParsed headParsed = this.headParsed_ = this.lastTagWasSynthesized_ ? HeadParsed.SYNTHESIZED : HeadParsed.YES;
        }
        if (namespaceURI != null) {
            namespaceURI = namespaceURI.trim();
        } else if (this.headParsed_ == HeadParsed.NO && ("body".equals(tagLower) || "frameset".equals(tagLower))) {
            ElementFactory factory2 = this.htmlParser_.getElementFactory(this.page_, null, "head", this.insideSvg_, false);
            DomElement newElement = factory2.createElement(this.page_, "head", null);
            HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, newElement);
            this.headParsed_ = HeadParsed.SYNTHESIZED;
        }
        HtmlBody oldBody = null;
        if ("body".equals(qName) && this.page_.getBody() instanceof HtmlBody) {
            oldBody = (HtmlBody)this.page_.getBody();
        }
        if (!(this.page_ instanceof XHtmlPage) && "http://www.w3.org/1999/xhtml".equals(namespaceURI)) {
            namespaceURI = null;
        }
        if ((factory = this.htmlParser_.getElementFactory(this.page_, namespaceURI, qName, this.insideSvg_, false)) == HtmlUnitNekoHtmlParser.SVG_FACTORY) {
            namespaceURI = "http://www.w3.org/2000/svg";
        }
        DomElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts, true);
        newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        this.addNodeToRightParent(this.currentNode_, newElement);
        if (newElement instanceof HtmlSvg) {
            this.insideSvg_ = true;
        }
        if (newElement instanceof HtmlForm) {
            this.consumingForm_ = (HtmlForm)newElement;
            this.formEndingIsAdjusting_ = false;
        } else if (this.consumingForm_ != null && newElement instanceof SubmittableElement && ((HtmlElement)newElement).getEnclosingForm() != this.consumingForm_) {
            this.consumingForm_.addLostChild((HtmlElement)newElement);
        }
        if (oldBody != null) {
            oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
        }
        if (!this.insideSvg_ && "body".equals(tagLower)) {
            this.body_ = (HtmlElement)newElement;
        } else if (newElement instanceof HtmlMeta && this.page_.hasFeature(BrowserVersionFeatures.META_X_UA_COMPATIBLE)) {
            String content;
            HtmlMeta meta = (HtmlMeta)newElement;
            if ("X-UA-Compatible".equals(meta.getHttpEquivAttribute()) && (content = meta.getContentAttribute()).startsWith("IE=")) {
                String mode = content.substring(3).trim();
                int version = this.page_.getWebClient().getBrowserVersion().getBrowserVersionNumeric();
                try {
                    int value = Integer.parseInt(mode);
                    if (value > version) {
                        value = version;
                    }
                    ((HTMLDocument)this.page_.getScriptableObject()).forceDocumentMode(value);
                }
                catch (Exception exception) {}
            }
        } else if (this.createdByJavascript_ && newElement instanceof ScriptElement) {
            ScriptElement script = (ScriptElement)((Object)newElement);
            script.markAsCreatedByDomParser();
        }
        this.currentNode_ = newElement;
        this.stack_.push(this.currentNode_);
    }

    private void addNodeToRightParent(DomNode currentNode, DomElement newElement) {
        String currentNodeName = currentNode.getNodeName();
        String newNodeName = newElement.getNodeName();
        if (HtmlUnitNekoDOMBuilder.isTableChild(newNodeName)) {
            DomNode parent = "table".equals(currentNodeName) ? currentNode : this.findElementOnStack("table");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if ("tr".equals(newNodeName)) {
            DomNode parent = HtmlUnitNekoDOMBuilder.isTableChild(currentNodeName) ? currentNode : this.findElementOnStack("tbody", "thead", "tfoot");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if (HtmlUnitNekoDOMBuilder.isTableCell(newNodeName)) {
            DomNode parent = "tr".equals(currentNodeName) ? currentNode : this.findElementOnStack("tr");
            HtmlUnitNekoDOMBuilder.appendChild(parent, newElement);
            return;
        }
        if ("table".equals(currentNodeName) || HtmlUnitNekoDOMBuilder.isTableChild(currentNodeName) || "tr".equals(currentNodeName)) {
            if ("template".equals(newNodeName)) {
                currentNode.appendChild(newElement);
            } else if (!"colgroup".equals(currentNodeName) && ("script".equals(newNodeName) || "form".equals(newNodeName) || "style".equals(newNodeName))) {
                currentNode.appendChild(newElement);
            } else if ("col".equals(newNodeName) && "colgroup".equals(currentNodeName)) {
                currentNode.appendChild(newElement);
            } else if ("caption".equals(currentNodeName)) {
                currentNode.appendChild(newElement);
            } else if (newElement instanceof HtmlHiddenInput) {
                currentNode.appendChild(newElement);
            } else {
                DomNode parent = this.findElementOnStack("table");
                parent.insertBefore(newElement);
            }
            return;
        }
        if (this.formEndingIsAdjusting_ && "form".equals(currentNodeName)) {
            HtmlUnitNekoDOMBuilder.appendChild(currentNode.getParentNode(), newElement);
            return;
        }
        HtmlUnitNekoDOMBuilder.appendChild(currentNode, newElement);
    }

    private DomNode findElementOnStack(String ... searchedElementNames) {
        DomNode searchedNode = null;
        for (DomNode node : this.stack_) {
            if (!ArrayUtils.contains((Object[])searchedElementNames, (Object)node.getNodeName())) continue;
            searchedNode = node;
            break;
        }
        if (searchedNode == null) {
            searchedNode = this.stack_.peek();
        }
        return searchedNode;
    }

    private static boolean isTableChild(String nodeName) {
        return "thead".equals(nodeName) || "tbody".equals(nodeName) || "tfoot".equals(nodeName) || "caption".equals(nodeName) || "colgroup".equals(nodeName);
    }

    private static boolean isTableCell(String nodeName) {
        return "td".equals(nodeName) || "th".equals(nodeName);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.lastTagWasSynthesized_ = HtmlUnitNekoDOMBuilder.isSynthesized(augs);
        super.endElement(element, augs);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String tagLower = StringUtils.toRootLowerCaseWithCache(localName);
        if (!"form".equals(tagLower) || !this.lastTagWasSynthesized_) {
            this.handleCharacters();
        }
        if (this.page_.isParsingHtmlSnippet()) {
            if ("html".equals(tagLower) || "body".equals(tagLower)) {
                return;
            }
            if (this.stack_.size() == this.initialSize_) {
                this.snippetStartNodeOverwritten_ = !"p".equals(tagLower);
                return;
            }
        }
        if ("svg".equals(tagLower)) {
            this.insideSvg_ = false;
        }
        if (this.stack_.isEmpty()) {
            return;
        }
        DomNode previousNode = this.stack_.pop();
        previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        if ("form".equals(tagLower) && !this.lastTagWasSynthesized_) {
            this.consumingForm_ = null;
        }
        if (!this.stack_.isEmpty()) {
            this.currentNode_ = this.stack_.peek();
        }
        boolean postponed = this.page_.isParsingInlineHtmlSnippet();
        previousNode.onAllChildrenAddedToPage(postponed);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters_.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters_.append(ch, start, length);
    }

    private void handleCharacters() {
        if (this.characters_.length() != 0) {
            if (this.currentNode_ instanceof HtmlHtml) {
                this.characters_.setLength(0);
            } else {
                String textValue = this.characters_.toString();
                DomText text = new DomText(this.page_, textValue);
                this.characters_.setLength(0);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)textValue)) {
                    if (this.currentNode_ instanceof HtmlTableRow) {
                        HtmlTableRow row = (HtmlTableRow)this.currentNode_;
                        HtmlTable enclosingTable = row.getEnclosingTable();
                        if (enclosingTable != null) {
                            if (enclosingTable.getPreviousSibling() instanceof DomText) {
                                DomText domText = (DomText)enclosingTable.getPreviousSibling();
                                domText.setTextContent(domText + textValue);
                            } else {
                                enclosingTable.insertBefore(text);
                            }
                        }
                    } else if (this.currentNode_ instanceof HtmlTable) {
                        HtmlTable enclosingTable = (HtmlTable)this.currentNode_;
                        if (enclosingTable.getPreviousSibling() instanceof DomText) {
                            DomText domText = (DomText)enclosingTable.getPreviousSibling();
                            domText.setTextContent(domText + textValue);
                        } else {
                            enclosingTable.insertBefore(text);
                        }
                    } else if (this.currentNode_ instanceof HtmlImage) {
                        this.currentNode_.getParentNode().appendChild(text);
                    } else {
                        HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, text);
                    }
                } else {
                    HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, text);
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.handleCharacters();
        this.page_.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.handleCharacters();
        String data = new String(ch, start, length);
        DomComment comment = new DomComment(this.page_, data);
        HtmlUnitNekoDOMBuilder.appendChild(this.currentNode_, comment);
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
        this.page_.setDocumentType(type);
        DomDocumentType child = type;
        this.page_.appendChild(child);
    }

    @Override
    public void startEntity(String name) {
    }

    public void ignoredEndElement(QName element, Augmentations augs) {
        if ("form".equals(element.localpart) && this.consumingForm_ != null) {
            this.consumingForm_ = null;
            if (!(this.findElementOnStack("table", "form") instanceof HtmlTable)) {
                this.formEndingIsAdjusting_ = true;
            }
        }
    }

    public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
        if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
            HtmlUnitNekoDOMBuilder.copyAttributes(this.body_, attrs);
        }
        if (this.body_ != null && "html".equalsIgnoreCase(elem.localpart) && attrs != null) {
            HtmlUnitNekoDOMBuilder.copyAttributes((DomElement)this.body_.getParentNode(), attrs);
        }
    }

    private static void copyAttributes(DomElement to, XMLAttributes attrs) {
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrName = StringUtils.toRootLowerCaseWithCache(attrs.getLocalName(i));
            if (to.getAttributes().getNamedItem(attrName) != null) continue;
            to.setAttribute(attrName, attrs.getValue(i));
            if (!attrName.startsWith("on") || !to.getPage().getWebClient().isJavaScriptEngineEnabled() || !(to.getScriptableObject() instanceof HTMLBodyElement)) continue;
            HTMLBodyElement jsBody = (HTMLBodyElement)to.getScriptableObject();
            jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
        }
    }

    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
        HTMLParserDOMBuilder oldBuilder = this.page_.getDOMBuilder();
        this.page_.setDOMBuilder(this);
        try {
            super.parse(inputSource);
        }
        finally {
            this.page_.setDOMBuilder(oldBuilder);
        }
    }

    HtmlElement getBody() {
        return this.body_;
    }

    private static boolean isSynthesized(Augmentations augs) {
        return augs instanceof HTMLEventInfo && ((HTMLEventInfo)augs).isSynthesized();
    }

    private static void appendChild(DomNode parent, DomNode child) {
        if (parent instanceof HtmlTemplate) {
            ((HtmlTemplate)parent).getContent().appendChild(child);
            return;
        }
        parent.appendChild(child);
    }

    static {
        int unknownId = 146;
        int isindexId = 147;
        int commandId = 148;
        int mainId = 149;
        HTMLElements.Element isIndex = new HTMLElements.Element(147, "ISINDEX", 8, 18, null);
        HTMLElements.Element isIndexSupported = new HTMLElements.Element(147, "ISINDEX", 2, 18, new short[]{147});
        HTMLElements.Element command = new HTMLElements.Element(148, "COMMAND", 4, new short[]{18, 56}, null);
        HTMLElements.Element main = new HTMLElements.Element(149, "MAIN", 1, 18, null);
        Triple key = Triple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE, (Object)Boolean.FALSE);
        HTMLElements value = new HTMLElements();
        value.setElement(isIndex);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE, (Object)Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(main);
        value.setElement(isIndex);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.FALSE, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(isIndexSupported);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.FALSE, (Object)Boolean.TRUE, (Object)Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(isIndexSupported);
        value.setElement(main);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.TRUE, (Object)Boolean.FALSE, (Object)Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndex);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.TRUE, (Object)Boolean.FALSE, (Object)Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndex);
        value.setElement(main);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.TRUE, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndexSupported);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
        key = Triple.of((Object)Boolean.TRUE, (Object)Boolean.TRUE, (Object)Boolean.TRUE);
        value = new HTMLElements();
        value.setElement(command);
        value.setElement(isIndexSupported);
        value.setElement(main);
        ELEMENTS.put((Triple<Boolean, Boolean, Boolean>)key, value);
    }

    private static enum HeadParsed {
        YES,
        SYNTHESIZED,
        NO;

    }
}

