/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.CssMediaList;
import org.htmlunit.cssparser.parser.media.MediaQuery;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.css.CSSStyleSheet;

@JsxClass
public class MediaList
extends HtmlUnitScriptable {
    private final CssMediaList cssMediaList_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public MediaList() {
        this.cssMediaList_ = null;
    }

    public MediaList(CSSStyleSheet parent, CssMediaList cssMediaList) {
        this.cssMediaList_ = cssMediaList;
        this.setParentScope((Scriptable)parent);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxFunction
    public String item(int index) {
        if (this.cssMediaList_ == null || index < 0 || index >= this.getLength()) {
            return null;
        }
        MediaQuery mq = this.cssMediaList_.getMediaQuery(index);
        return mq.toString();
    }

    @JsxGetter
    public int getLength() {
        if (this.cssMediaList_ == null) {
            return 0;
        }
        return this.cssMediaList_.getLength();
    }

    @JsxGetter
    public String getMediaText() {
        if (this.cssMediaList_ == null) {
            return null;
        }
        return this.cssMediaList_.getMediaText();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && this.cssMediaList_ != null) {
            if (this.cssMediaList_.getLength() == 0) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_EMPTY_STRING)) {
                    return "";
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_ALL)) {
                    return "all";
                }
            }
            return this.cssMediaList_.getMediaText();
        }
        return super.getDefaultValue(hint);
    }
}

