/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.IOException;
import org.apache.commons.lang3.math.NumberUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlDateTimeLocalInput;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlMonthInput;
import org.htmlunit.html.HtmlNumberInput;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.HtmlTimeInput;
import org.htmlunit.html.HtmlWeekInput;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.dom.TextRange;
import org.htmlunit.javascript.host.file.FileList;
import org.htmlunit.javascript.host.html.HTMLCanvasElement;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;
import org.htmlunit.javascript.host.html.ValidityState;
import org.htmlunit.util.StringUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlInput.class)
public class HTMLInputElement
extends HTMLElement {
    private NodeList labels_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLInputElement() {
    }

    @JsxGetter
    public String getType() {
        BrowserVersion browserVersion = this.getBrowserVersion();
        String type = this.getDomNodeOrDie().getTypeAttribute();
        return HTMLInputElement.isSupported(type = StringUtils.toRootLowerCaseWithCache(type), browserVersion) ? type : "text";
    }

    private static boolean isSupported(String type, BrowserVersion browserVersion) {
        boolean supported = false;
        switch (type) {
            case "date": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "datetime-local": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_LOCAL_SUPPORTED);
                break;
            }
            case "month": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED);
                break;
            }
            case "time": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "week": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED);
                break;
            }
            case "color": {
                supported = !browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_COLOR_NOT_SUPPORTED);
                break;
            }
            case "email": 
            case "text": 
            case "submit": 
            case "checkbox": 
            case "radio": 
            case "hidden": 
            case "password": 
            case "image": 
            case "reset": 
            case "button": 
            case "file": 
            case "number": 
            case "range": 
            case "search": 
            case "tel": 
            case "url": {
                supported = true;
                break;
            }
        }
        return supported;
    }

    @JsxSetter
    public void setType(String newType) {
        this.setType(newType, false);
    }

    private void setType(String newType, boolean setThroughAttribute) {
        HtmlInput input = this.getDomNodeOrDie();
        String currentType = input.getAttributeDirect("type");
        BrowserVersion browser = this.getBrowserVersion();
        if (!currentType.equalsIgnoreCase(newType)) {
            AttributesImpl attributes;
            int index;
            if (newType != null && browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_TYPE_LOWERCASE)) {
                newType = StringUtils.toRootLowerCaseWithCache(newType);
            }
            if (!HTMLInputElement.isSupported(StringUtils.toRootLowerCaseWithCache(newType), browser)) {
                if (setThroughAttribute) {
                    newType = "text";
                } else if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_UNSUPORTED_TYPE_EXCEPTION)) {
                    throw Context.reportRuntimeError((String)("Invalid argument '" + newType + "' for setting property type."));
                }
            }
            if ((index = (attributes = this.readAttributes(input)).getIndex("type")) > -1) {
                attributes.setValue(index, newType);
            } else {
                attributes.addAttribute(null, "type", "type", null, newType);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != currentType || !"text".equalsIgnoreCase(newType)) {
                SgmlPage page = input.getPage();
                HtmlInput newInput = (HtmlInput)page.getWebClient().getPageCreator().getHtmlParser().getFactory("input").createElement(page, "input", attributes);
                if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_CHANGE_TYPE_DROPS_VALUE)) {
                    if (!(newInput instanceof HtmlSubmitInput || newInput instanceof HtmlResetInput || newInput instanceof HtmlCheckBoxInput || newInput instanceof HtmlRadioButtonInput || newInput instanceof HtmlImageInput)) {
                        newInput.setRawValue(input.getRawValue());
                    }
                } else if (newInput instanceof HtmlTimeInput || newInput instanceof HtmlDateTimeLocalInput || newInput instanceof HtmlFileInput) {
                    newInput.setValue("");
                } else if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_CHANGE_TYPE_DROPS_VALUE_WEEK_MONTH) && (newInput instanceof HtmlWeekInput || newInput instanceof HtmlMonthInput)) {
                    newInput.setValue("");
                } else {
                    String originalValue = input.getValue();
                    if (DomElement.ATTRIBUTE_NOT_DEFINED != originalValue) {
                        newInput.setValue(originalValue);
                    }
                }
                if (input.wasCreatedByJavascript()) {
                    newInput.markAsCreatedByJavascript();
                }
                if (input.getParentNode() == null) {
                    input = newInput;
                } else {
                    input.getParentNode().replaceChild(newInput, input);
                }
                input.setScriptableObject(null);
                this.setDomNode(newInput, true);
            } else {
                super.setAttribute("type", newType);
            }
        }
    }

    @Override
    @JsxSetter
    public void setValue(Object newValue) {
        if (null == newValue) {
            this.getDomNodeOrDie().setValue("");
            this.getDomNodeOrDie().valueModifiedByJavascript();
            return;
        }
        String val = Context.toString((Object)newValue);
        if ("file".equalsIgnoreCase(this.getType())) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)val) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_FILE_THROWS)) {
                throw Context.reportRuntimeError((String)"InvalidStateError: Failed to set the 'value' property on 'HTMLInputElement'.");
            }
            return;
        }
        this.getDomNodeOrDie().setValue(val);
        this.getDomNodeOrDie().valueModifiedByJavascript();
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        this.getDomNodeOrDie().setChecked(checked);
    }

    @Override
    public HtmlInput getDomNodeOrDie() {
        return (HtmlInput)super.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean isChecked() {
        return this.getDomNodeOrDie().isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getDomNodeOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)input).select();
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("type".equalsIgnoreCase(name)) {
            this.setType(value, true);
            return;
        }
        if ("value".equalsIgnoreCase(name)) {
            this.setDefaultValue(value);
            return;
        }
        super.setAttribute(name, value);
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean isDefaultChecked() {
        return this.getDomNodeOrDie().isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        this.getDomNodeOrDie().setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public Object getSelectionStart() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionStart();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILE_SELECTION_START_END_NULL)) {
            return null;
        }
        throw Context.reportRuntimeError((String)("Failed to read the 'selectionStart' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                throw Context.reportRuntimeError((String)"Failed to set the 'selectionStart' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.");
            }
            ((SelectableTextInput)((Object)dom)).setSelectionStart(start);
            return;
        }
        throw Context.reportRuntimeError((String)("Failed to set the 'selectionStart' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxGetter
    public Object getSelectionEnd() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionEnd();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILE_SELECTION_START_END_NULL)) {
            return null;
        }
        throw Context.reportRuntimeError((String)("Failed to read the 'selectionEnd' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                throw Context.reportRuntimeError((String)"Failed to set the 'selectionEnd' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.");
            }
            ((SelectableTextInput)((Object)dom)).setSelectionEnd(end);
            return;
        }
        throw Context.reportRuntimeError((String)("Failed to set the 'selectionEnd' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setMaxLength(length);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getMinLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("minLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setMinLength(int length) {
        this.getDomNodeOrDie().setMinLength(length);
    }

    @JsxGetter
    public String getMin() {
        return this.getDomNodeOrDie().getAttributeDirect("min");
    }

    @JsxSetter
    public void setMin(String min) {
        this.getDomNodeOrDie().setAttribute("min", min);
    }

    @JsxGetter
    public String getMax() {
        return this.getDomNodeOrDie().getAttributeDirect("max");
    }

    @JsxSetter
    public void setMax(String max) {
        this.getDomNodeOrDie().setAttribute("max", max);
    }

    @JsxGetter
    public String getStep() {
        return this.getDomNodeOrDie().getAttributeDirect("step");
    }

    @JsxSetter
    public void setStep(String step) {
        this.getDomNodeOrDie().setAttribute("step", step);
    }

    @JsxGetter
    public boolean isReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES)) {
            return "";
        }
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES);
        this.setAlign(align, ignoreIfNoError);
    }

    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getSrc();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setSrcAttribute(src);
    }

    @Override
    @JsxGetter
    public String getValue() {
        String valueAttr;
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlNumberInput && !(valueAttr = htmlInput.getValue()).isEmpty()) {
            if ("-".equals(valueAttr) || "+".equals(valueAttr)) {
                return "";
            }
            int lastPos = valueAttr.length() - 1;
            if (lastPos >= 0 && valueAttr.charAt(lastPos) == '.' && htmlInput.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                return "";
            }
            try {
                Double.parseDouble(valueAttr);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        return htmlInput.getValue();
    }

    @Override
    public String getAttribute(String attributeName, Integer flags) {
        String superAttribute = super.getAttribute(attributeName, flags);
        if ("value".equalsIgnoreCase(attributeName)) {
            if ((superAttribute == null || !superAttribute.isEmpty()) && this.getDefaultValue().isEmpty()) {
                return null;
            }
            if (!"file".equals(this.getType())) {
                return this.getDefaultValue();
            }
        }
        return superAttribute;
    }

    @Override
    public void click() throws IOException {
        HtmlInput domNode = this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        domNode.click(false, false, false, false, false, true, false);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput)) {
            domNode.fireEvent("change");
        }
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @JsxGetter
    public String getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setSize(size);
    }

    @JsxGetter
    public String getAccept() {
        return this.getDomNodeOrDie().getAccept();
    }

    @JsxSetter
    public void setAccept(String accept) {
        this.getDomNodeOrDie().setAccept(accept);
    }

    @JsxGetter
    public String getAutocomplete() {
        return this.getDomNodeOrDie().getAutocomplete();
    }

    @JsxSetter
    public void setAutocomplete(String autocomplete) {
        this.getDomNodeOrDie().setAutocomplete(autocomplete);
    }

    @JsxGetter
    public Object getFiles() {
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlFileInput) {
            FileList list = new FileList(((HtmlFileInput)htmlInput).getFiles());
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            return list;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILES_UNDEFINED)) {
            return Undefined.instance;
        }
        return null;
    }

    @JsxGetter
    public String getPlaceholder() {
        return this.getDomNodeOrDie().getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        this.getDomNodeOrDie().setPlaceholder(placeholder);
    }

    @JsxGetter
    public int getWidth() {
        String value = this.getDomNodeOrDie().getAttributeDirect("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setWidth(int width) {
        this.getDomNodeOrDie().setAttribute("width", Integer.toString(width));
    }

    @JsxGetter
    public int getHeight() {
        String value = this.getDomNodeOrDie().getAttributeDirect("height");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setHeight(int height) {
        this.getDomNodeOrDie().setAttribute("height", Integer.toString(height));
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public TextRange createTextRange() {
        return super.createTextRange();
    }

    @Override
    @JsxGetter
    public String getName() {
        return super.getName();
    }

    @Override
    @JsxSetter
    public void setName(String newName) {
        super.setName(newName);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        return super.getForm();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean getWillValidate() {
        return this.getDomNodeOrDie().willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        this.getDomNodeOrDie().setCustomValidity(message);
    }

    @JsxGetter
    public boolean isFormNoValidate() {
        return this.getDomNodeOrDie().isFormNoValidate();
    }

    @JsxSetter
    public void setFormNoValidate(boolean value) {
        this.getDomNodeOrDie().setFormNoValidate(value);
    }
}

