/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableBody;
import org.htmlunit.html.HtmlTableFooter;
import org.htmlunit.html.HtmlTableHeader;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLTableCaptionElement;
import org.htmlunit.javascript.host.html.HTMLTableSectionElement;
import org.htmlunit.javascript.host.html.RowContainer;
import org.w3c.dom.NodeList;

@JsxClass(domClass=HtmlTable.class)
public class HTMLTableElement
extends RowContainer {
    private static final List<String> VALID_RULES_ = Arrays.asList("none", "groups", "rows", "cols");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLTableElement() {
    }

    @JsxGetter
    public Object getCaption() {
        NodeList captions = this.getDomNodeOrDie().getElementsByTagName("caption");
        if (captions.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(captions.get(0));
    }

    @JsxSetter
    public void setCaption(Object o) {
        if (!(o instanceof HTMLTableCaptionElement)) {
            throw Context.reportRuntimeError((String)"Not a caption");
        }
        this.deleteCaption();
        HTMLTableCaptionElement caption = (HTMLTableCaptionElement)o;
        this.getDomNodeOrDie().appendChild(caption.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTFoot() {
        NodeList tfoots = this.getDomNodeOrDie().getElementsByTagName("tfoot");
        if (tfoots.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(tfoots.get(0));
    }

    @JsxSetter
    public void setTFoot(Object o) {
        if (!(o instanceof HTMLTableSectionElement) || !"TFOOT".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError((String)"Not a tFoot");
        }
        this.deleteTFoot();
        HTMLTableSectionElement tfoot = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(tfoot.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTHead() {
        NodeList theads = this.getDomNodeOrDie().getElementsByTagName("thead");
        if (theads.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(theads.get(0));
    }

    @JsxSetter
    public void setTHead(Object o) {
        if (!(o instanceof HTMLTableSectionElement) || !"THEAD".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError((String)"Not a tHead");
        }
        this.deleteTHead();
        HTMLTableSectionElement thead = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(thead.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTBodies() {
        HtmlTable table = (HtmlTable)this.getDomNodeOrDie();
        HTMLCollection bodies = new HTMLCollection((DomNode)table, false);
        bodies.setElementsSupplier((Supplier<List> & Serializable)() -> new ArrayList<HtmlTableBody>(table.getBodies()));
        return bodies;
    }

    @JsxFunction
    public Object createCaption() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("caption"));
    }

    @JsxFunction
    public Object createTFoot() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("tfoot"));
    }

    @JsxFunction
    public Object createTBody() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("tbody"));
    }

    @JsxFunction
    public Object createTHead() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("thead"));
    }

    @JsxFunction
    public void deleteCaption() {
        this.getDomNodeOrDie().removeChild("caption", 0);
    }

    @JsxFunction
    public void deleteTFoot() {
        this.getDomNodeOrDie().removeChild("tfoot", 0);
    }

    @JsxFunction
    public void deleteTHead() {
        this.getDomNodeOrDie().removeChild("thead", 0);
    }

    @Override
    protected boolean isContainedRow(HtmlTableRow row) {
        DomNode parent = row.getParentNode();
        return parent != null && parent.getParentNode() == this.getDomNodeOrDie();
    }

    @Override
    public Object insertRow(int index) {
        if (index != 0) {
            for (DomNode domNode : this.getDomNodeOrDie().getDescendants()) {
                if (!(domNode instanceof HtmlTableBody) && !(domNode instanceof HtmlTableHeader) && !(domNode instanceof HtmlTableFooter)) continue;
                return super.insertRow(index);
            }
        }
        HtmlElement tBody = this.getDomNodeOrDie().appendChildIfNoneExists("tbody");
        return ((RowContainer)this.getScriptableFor(tBody)).insertRow(0);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getDomNodeOrDie().getAttributeDirect("width");
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @JsxGetter
    public String getCellSpacing() {
        return this.getDomNodeOrDie().getAttributeDirect("cellspacing");
    }

    @JsxSetter
    public void setCellSpacing(String cellSpacing) {
        this.getDomNodeOrDie().setAttribute("cellspacing", cellSpacing);
    }

    @JsxGetter
    public String getCellPadding() {
        return this.getDomNodeOrDie().getAttributeDirect("cellpadding");
    }

    @JsxSetter
    public void setCellPadding(String cellPadding) {
        this.getDomNodeOrDie().setAttribute("cellpadding", cellPadding);
    }

    @JsxGetter
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColor() {
        return this.getDomNodeOrDie().getAttribute("borderColor");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColor(String borderColor) {
        this.setColorAttribute("borderColor", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorDark() {
        return this.getDomNodeOrDie().getAttribute("borderColorDark");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorDark(String borderColor) {
        this.setColorAttribute("borderColorDark", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorLight() {
        return this.getDomNodeOrDie().getAttribute("borderColorLight");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorLight(String borderColor) {
        this.setColorAttribute("borderColorLight", borderColor);
    }

    @Override
    public Object appendChild(Object childObject) {
        Object appendedChild = super.appendChild(childObject);
        this.getDomNodeOrDie().getPage().clearComputedStyles(this.getDomNodeOrDie());
        return appendedChild;
    }

    @Override
    public Object removeChild(Object childObject) {
        Object removedChild = super.removeChild(childObject);
        this.getDomNodeOrDie().getPage().clearComputedStyles(this.getDomNodeOrDie());
        return removedChild;
    }

    @JsxGetter
    public String getSummary() {
        return this.getDomNodeOrDie().getAttributeDirect("summary");
    }

    @JsxSetter
    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    @JsxGetter
    public String getRules() {
        String rules = this.getDomNodeOrDie().getAttributeDirect("rules");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_VALIGN_SUPPORTS_IE_VALUES) && !VALID_RULES_.contains(rules)) {
            rules = "";
        }
        return rules;
    }

    @JsxSetter
    public void setRules(String rules) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_VALIGN_SUPPORTS_IE_VALUES) && !(rules = rules.toLowerCase(Locale.ROOT)).isEmpty() && !VALID_RULES_.contains(rules)) {
            throw Context.throwAsScriptRuntimeEx((Throwable)new Exception("Invalid argument"));
        }
        this.setAttribute("rules", rules);
    }
}

