/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.ParameterCheckUtils;

public class Balancer {
    private final String openingDelimiter;
    private final String closingDelimiter;
    private static final String ERROR_MSG = "The string '%s' is unbalanced.";

    public Balancer(String openingDelimiter, String closingDelimiter) {
        ParameterCheckUtils.isNotNullOrEmpty(openingDelimiter, "openingDelimiter");
        ParameterCheckUtils.isNotNullOrEmpty(closingDelimiter, "closingDelimiter");
        this.openingDelimiter = openingDelimiter;
        this.closingDelimiter = closingDelimiter;
    }

    public void check(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        int counter = 0;
        int delimMinLength = Math.min(this.openingDelimiter.length(), this.closingDelimiter.length());
        int delimMaxLength = Math.max(this.openingDelimiter.length(), this.closingDelimiter.length());
        for (int i = 0; i < s.length() - delimMinLength + 1; ++i) {
            boolean eatMost = i < s.length() - delimMaxLength + 1;
            String snippet = s.substring(i, i + (eatMost ? delimMaxLength : delimMinLength));
            int result = this.checkSnippet(snippet);
            if (result < 0) {
                if (counter == 0) continue;
                i += this.closingDelimiter.length() - 1;
            } else if (result > 0) {
                i += this.openingDelimiter.length() - 1;
            }
            counter += result;
        }
        if (counter != 0) {
            String errMsg = String.format(ERROR_MSG, s);
            throw new IllegalArgumentException("There are " + counter + " unclosed references to variable values. " + errMsg);
        }
    }

    private int checkSnippet(String snippet) {
        if (snippet.length() >= this.openingDelimiter.length() && snippet.startsWith(this.openingDelimiter)) {
            return 1;
        }
        if (snippet.length() >= this.closingDelimiter.length() && snippet.startsWith(this.closingDelimiter)) {
            return -1;
        }
        return 0;
    }
}

