/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.tests;

import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.junit.JavaTestCaseRunner;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.engine.util.URLInfo;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=JavaTestCaseRunner.class)
public abstract class AbstractTestCase {
    private long startTime;
    private Map<String, String> testDataSet;
    private String testName;

    @Before
    public final void __setup() {
        String id = String.valueOf(GlobalClock.get().millis());
        Session.getCurrent().setID(id);
        SessionImpl session = (SessionImpl)Session.getCurrent();
        if (!session.isLoadTest()) {
            session.setUserName(this.getSimpleName());
            Thread.currentThread().setName(session.getUserID());
        }
        session.setTestCaseClassName(this.getTestName());
        session.setTestInstance(this);
        session.getValueLog().put("com.xceptance.xlt.random.initValue", XltRandom.getSeed());
    }

    @After
    public final void __tearDown() {
        XltRandom.reseed();
    }

    public String getProperty(String key) {
        String effectiveKey = this.getEffectiveKey(key);
        return XltProperties.getInstance().getProperty(effectiveKey);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String effectiveKey = this.getEffectiveKey(key);
        return XltProperties.getInstance().getProperty(effectiveKey, defaultValue);
    }

    public int getProperty(String key, int defaultValue) {
        String effectiveKey = this.getEffectiveKey(key);
        return XltProperties.getInstance().getProperty(effectiveKey, defaultValue);
    }

    public String getProperty(String key, String defaultValue) {
        String effectiveKey = this.getEffectiveKey(key);
        return XltProperties.getInstance().getProperty(effectiveKey, defaultValue);
    }

    public Map<String, String> getTestDataSet() {
        return this.testDataSet;
    }

    public String reconfigureStartUrl(String urlString) throws Exception {
        String protocol = this.getProperty("startUrl.protocol", "");
        String userInfo = this.getProperty("startUrl.userInfo", "");
        String host = this.getProperty("startUrl.host", "");
        int port = this.getProperty("startUrl.port", -1);
        String path = this.getProperty("startUrl.path", "");
        String query = this.getProperty("startUrl.query", "");
        String fragment = this.getProperty("startUrl.fragment", "");
        URLInfo urlInfo = URLInfo.builder().proto(protocol).userInfo(userInfo).host(host).port(port).path(path).query(query).fragment(fragment).build();
        return UrlUtils.rewriteUrl(urlString, urlInfo).toExternalForm();
    }

    public void setTestDataSet(Map<String, String> testDataSet) {
        this.testDataSet = testDataSet;
    }

    @Before
    public void setUp() {
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("####### Test '%s' started", this.getTestName()));
        }
        this.startTime = TimerUtils.get().getStartTime();
    }

    @After
    public void tearDown() {
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("####### Test '%s' finished after %d ms", this.getTestName(), TimerUtils.get().getElapsedTime(this.startTime)));
        }
    }

    protected String getEffectiveKey(String bareKey) {
        String classNameQualifiedKey;
        String userNameQualifiedKey;
        XltProperties xltProperties = XltProperties.getInstance();
        Object effectiveKey = xltProperties.containsKey(userNameQualifiedKey = Session.getCurrent().getUserName() + "." + bareKey) ? userNameQualifiedKey : (xltProperties.containsKey(classNameQualifiedKey = this.getTestName() + "." + bareKey) ? classNameQualifiedKey : bareKey);
        return effectiveKey;
    }

    protected String getSimpleName() {
        String name = this.getTestName();
        int idx = Math.max(name.lastIndexOf(46), name.lastIndexOf(36));
        if (idx != -1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    protected String getTestName() {
        if (this.testName == null) {
            this.testName = this.getClass().getName();
        }
        return this.testName;
    }

    @Deprecated
    protected void setTestName() {
    }

    protected void setTestName(String testName) {
        if (StringUtils.isNotBlank((CharSequence)testName)) {
            this.testName = testName;
        } else {
            this.testName = this.getClass().getName();
            XltLogger.runTimeLogger.warn("A test name should not be blank, empty, or null. Used \"" + testName + "\" instead!");
        }
    }
}

