/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.xml.XSLTUtils;
import com.xceptance.xlt.report.util.TaskManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class ReportTransformer {
    private final List<File> outputFiles;
    private final List<File> styleSheetFiles;
    private final Map<String, Object> parameters;

    public ReportTransformer(List<File> outputFiles, List<File> styleSheetFiles, Map<String, Object> parameters) {
        this.outputFiles = outputFiles;
        this.styleSheetFiles = styleSheetFiles;
        this.parameters = parameters;
    }

    public void run(final File inputXmlFile, File outputDir) {
        for (int i = 0; i < this.outputFiles.size(); ++i) {
            final File outputFile = this.outputFiles.get(i);
            final File styleSheetFile = this.styleSheetFiles.get(i);
            TaskManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    ReportTransformer.this.transformReport(inputXmlFile, outputFile, styleSheetFile);
                }
            });
        }
    }

    protected void transformReport(File inputXmlFile, File outputFile, File xsltStyleSheet) {
        try {
            XSLTUtils.transform(inputXmlFile, outputFile, xsltStyleSheet, this.parameters);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("Could not setup transformation engine: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find file(s): " + e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println("Could not transform XML into target: " + e.getMessage());
        }
    }
}

