/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.providers.SlowRequestReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SlowestRequestsTracker {
    private final int capacity;
    private long minimumStoredRuntime = -1L;
    private final TreeSet<SlowRequestReport> slowestRequests = new TreeSet();
    private final Map<String, SlowRequestReport> slowestRequestsByUrl = new HashMap<String, SlowRequestReport>();

    public SlowestRequestsTracker(int capacity) {
        ParameterCheckUtils.isGreaterThan(capacity, 0, "capacity");
        this.capacity = capacity;
    }

    public void update(RequestData requestData) {
        long runtime = requestData.getRunTime();
        if (runtime > this.minimumStoredRuntime) {
            String url = requestData.getUrl().toString();
            SlowRequestReport requestReport = this.slowestRequestsByUrl.get(url);
            if (requestReport == null) {
                if (this.slowestRequests.size() == this.capacity) {
                    SlowRequestReport old = this.slowestRequests.last();
                    this.slowestRequests.remove(old);
                    this.slowestRequestsByUrl.remove(old.url);
                }
                requestReport = new SlowRequestReport();
                requestReport.url = url;
                requestReport.runtime = runtime;
                this.slowestRequests.add(requestReport);
                this.slowestRequestsByUrl.put(url, requestReport);
            } else if (runtime > requestReport.runtime) {
                this.slowestRequests.remove(requestReport);
                requestReport.runtime = runtime;
                this.slowestRequests.add(requestReport);
            }
            if (this.slowestRequests.size() == this.capacity) {
                this.minimumStoredRuntime = this.slowestRequests.last().runtime;
            }
        }
    }

    public List<SlowRequestReport> getSlowestRequests() {
        return new ArrayList<SlowRequestReport>(this.slowestRequests);
    }
}

