/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.CustomData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.providers.ActionDataProcessor;
import com.xceptance.xlt.report.providers.ActionReport;
import com.xceptance.xlt.report.providers.AgentDataProcessor;
import com.xceptance.xlt.report.providers.CustomDataProcessor;
import com.xceptance.xlt.report.providers.CustomTimerReport;
import com.xceptance.xlt.report.providers.PageLoadTimingDataProcessor;
import com.xceptance.xlt.report.providers.PageLoadTimingReport;
import com.xceptance.xlt.report.providers.RequestDataProcessor;
import com.xceptance.xlt.report.providers.RequestReport;
import com.xceptance.xlt.report.providers.SummaryReport;
import com.xceptance.xlt.report.providers.TransactionDataProcessor;
import com.xceptance.xlt.report.providers.TransactionReport;

public class SummaryReportProvider
extends AbstractReportProvider {
    private TransactionDataProcessor transactionDataProcessor;
    private ActionDataProcessor actionDataProcessor;
    private RequestDataProcessor requestDataProcessor;
    private PageLoadTimingDataProcessor pageLoadDataProcessor;
    private CustomDataProcessor customTimerDataProcessor;
    private AgentDataProcessor agentDataProcessor;

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.transactionDataProcessor = new TransactionDataProcessor("All Transactions", this);
        this.actionDataProcessor = new ActionDataProcessor("All Actions", this);
        this.requestDataProcessor = new RequestDataProcessor("All Requests", this, false);
        this.pageLoadDataProcessor = new PageLoadTimingDataProcessor("All Page Load Timings", this);
        this.customTimerDataProcessor = new CustomDataProcessor("All Custom Timers", this);
        this.agentDataProcessor = new AgentDataProcessor("All Agents", this);
    }

    @Override
    public Object createReportFragment() {
        SummaryReport report = new SummaryReport();
        report.transactions = (TransactionReport)this.transactionDataProcessor.createTimerReport(false);
        report.actions = (ActionReport)this.actionDataProcessor.createTimerReport(false);
        report.requests = (RequestReport)this.requestDataProcessor.createTimerReport(true);
        report.pageLoadTimings = (PageLoadTimingReport)this.pageLoadDataProcessor.createTimerReport(false);
        report.customTimers = (CustomTimerReport)this.customTimerDataProcessor.createTimerReport(false);
        report.agents = this.agentDataProcessor.createAgentReport();
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            this.requestDataProcessor.processDataRecord(data);
        } else if (data instanceof ActionData) {
            this.actionDataProcessor.processDataRecord(data);
        } else if (data instanceof TransactionData || data instanceof EventData) {
            this.transactionDataProcessor.processDataRecord(data);
        } else if (data instanceof PageLoadTimingData) {
            this.pageLoadDataProcessor.processDataRecord(data);
        } else if (data instanceof CustomData) {
            this.customTimerDataProcessor.processDataRecord(data);
        } else if (data instanceof JvmResourceUsageData) {
            this.agentDataProcessor.processDataRecord(data);
        }
    }
}

